/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.Fmt;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TextFrame;
import com.vividsolutions.jump.workbench.ui.plugin.WKTDisplayHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;

public class VerticesInFencePlugIn
extends AbstractPlugIn {
    private final WKTWriter wktWriter = new WKTWriter(3);
    private final GeometryFactory factory = new GeometryFactory();
    private final WKTDisplayHelper helper = new WKTDisplayHelper();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        TextFrame textFrame = new TextFrame(context.getWorkbenchFrame());
        textFrame.setTitle(I18N.getInstance().get("ui.plugin.VerticesInFencePlugIn.vertices-in-fence"));
        textFrame.clear();
        textFrame.setText(this.description(context));
        textFrame.setSize(550, 300);
        context.getWorkbenchFrame().addInternalFrame(textFrame);
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck());
    }

    private String description(PlugInContext context) {
        FenceLayerFinder fenceLayerFinder = new FenceLayerFinder(context);
        StringBuilder description = new StringBuilder();
        description.append("<html><body>");
        Iterator<Layer> i = context.getLayerManager().iterator(Layer.class);
        while (i.hasNext()) {
            Layer layer = i.next();
            if (!layer.isVisible() || layer == fenceLayerFinder.getLayer()) continue;
            description.append(this.description(layer, context));
        }
        description.append("</body></html>");
        return description.toString();
    }

    public static Collection<Coordinate> verticesInFence(Collection<Geometry> geometries, Geometry fence, boolean skipClosingVertex) {
        ArrayList<Coordinate> verticesInFence = new ArrayList<Coordinate>();
        for (Geometry geometry : geometries) {
            verticesInFence.addAll(VerticesInFencePlugIn.verticesInFence(geometry, fence, skipClosingVertex).getCoordinates());
        }
        return verticesInFence;
    }

    public static VerticesInFence verticesInFence(Geometry geometry, final Geometry fence, final boolean skipClosingVertex) {
        final ArrayList coordinates = new ArrayList();
        final ArrayList indices = new ArrayList();
        final PointLocator pointLocator = new PointLocator();
        final IntWrapper index = new IntWrapper(-1);
        geometry.apply(new GeometryComponentFilter(){

            public void filter(Geometry geometry) {
                if (geometry instanceof GeometryCollection || geometry instanceof Polygon) {
                    return;
                }
                Coordinate[] component = geometry.getCoordinates();
                for (int j = 0; j < component.length; ++j) {
                    ++index.value;
                    if (skipClosingVertex && component.length > 1 && j == component.length - 1 && component[j].equals((Object)component[0]) || pointLocator.locate(component[j], fence) == 2) continue;
                    coordinates.add(component[j]);
                    indices.add(index.value);
                }
            }
        });
        return new VerticesInFence(){

            @Override
            public List<Coordinate> getCoordinates() {
                return coordinates;
            }

            @Override
            public int getIndex(int i) {
                return (Integer)indices.get(i);
            }
        };
    }

    private String description(Layer layer, PlugInContext context) {
        boolean foundVertices = false;
        String description = "<Table width=100%><tr><td colspan=2 valign=top><i>" + I18N.getInstance().get("ui.plugin.VerticesInFencePlugIn.layer") + " </i><font color='#3300cc'><b>" + layer.getName() + "</b></font></td></tr>";
        String bgcolor = "darkgrey";
        for (Feature feature : layer.getFeatureCollectionWrapper().query(context.getLayerViewPanel().getFence().getEnvelopeInternal())) {
            VerticesInFence verticesInFence = VerticesInFencePlugIn.verticesInFence(feature.getGeometry(), context.getLayerViewPanel().getFence(), true);
            if (verticesInFence.getCoordinates().isEmpty()) continue;
            bgcolor = bgcolor.equals("#faebd7") ? "darkgrey" : "#faebd7";
            foundVertices = true;
            description = description + "<tr bgcolor=" + bgcolor + "><td width=10% valign=top><font size='-1'><i>" + I18N.getInstance().get("ui.plugin.VerticesInFencePlugIn.feature-id") + " </i></font><font size='-1' color='#3300cc'><b>" + feature.getID() + "</b></font><td>";
            description = description + this.description(verticesInFence, feature.getGeometry());
            description = description + "</td></tr>";
        }
        description = description + "</table>";
        return foundVertices ? description : "";
    }

    private String description(VerticesInFence verticesInFence, Geometry geometry) {
        StringBuilder description = new StringBuilder();
        description.append("<pre>");
        for (int i = 0; i < verticesInFence.getCoordinates().size(); ++i) {
            description.append(GUIUtil.escapeHTML("[" + Fmt.fmt(this.helper.annotation(geometry, verticesInFence.getCoordinates().get(i)), 10) + "] " + this.wktWriter.write((Geometry)this.factory.createPoint(verticesInFence.getCoordinates().get(i))) + "\n", false, false));
        }
        description.append("</pre>");
        return description.toString();
    }

    public static void main(String[] args) {
        new WKTWriter();
        new Object();
    }

    private static class IntWrapper {
        public int value;

        public IntWrapper(int value) {
            this.value = value;
        }
    }

    public static interface VerticesInFence {
        public List<Coordinate> getCoordinates();

        public int getIndex(int var1);
    }
}

