/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.io.Closeable;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class GenerateLogPlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.GenerateLogPlugIn.log");
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.icon("application_view_list.png");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        HTMLFrame f = new HTMLFrame(context.getWorkbenchFrame());
        List<File> files = Logger.getLogFiles();
        Iterator<File> iterator = files.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                f.surface();
                return true;
            }
            File file = iterator.next();
            StringBuffer buf = new StringBuffer();
            if (!file.canRead()) {
                buf.append("can't read " + file.getAbsolutePath());
            } else {
                int max_lines = 1000;
                ReversedLinesFileReader rlrdr = null;
                try {
                    String line;
                    rlrdr = new ReversedLinesFileReader(file, 4096, "UTF-8");
                    for (int counter = 0; (line = rlrdr.readLine()) != null && counter < max_lines; ++counter) {
                        buf.insert(0, GUIUtil.escapeHTML(line, false, true) + "<br>");
                    }
                    buf.insert(0, "last " + max_lines + " lines of " + file.getAbsolutePath() + ":<br><hr>");
                }
                catch (Throwable throwable) {
                    FileUtil.close(rlrdr);
                    throw throwable;
                }
                FileUtil.close((Closeable)rlrdr);
            }
            f.createNewDocument();
            f.addHeader(1, file.getName());
            f.addHeader(2, I18N.getInstance().get("ui.plugin.GenerateLogPlugIn.generated") + " " + new Date());
            f.append(buf.toString());
        }
    }
}

