/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchProperties;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.CheckBoxed;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.EnableChecked;
import com.vividsolutions.jump.workbench.plugin.Iconified;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.MultiShortcutEnabled;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.ShortcutEnabled;
import com.vividsolutions.jump.workbench.ui.AttributeTab;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.ShortcutPluginExecuteKeyListener;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.MenuItemShownListener;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.locationtech.jts.util.Assert;
import org.openjump.core.CheckOS;
import org.openjump.core.ui.plugin.AbstractUiPlugIn;
import org.openjump.core.ui.plugin.layer.pirolraster.RasterImageContextMenu;
import org.openjump.core.ui.swing.listener.EnableCheckMenuItemShownListener;

public class FeatureInstaller {
    private static Map<WorkbenchContext, FeatureInstaller> instances = new HashMap<WorkbenchContext, FeatureInstaller>();
    private WorkbenchContext workbenchContext;
    private TaskMonitorManager taskMonitorManager = new TaskMonitorManager();
    private EnableCheckFactory checkFactory;
    private static Map<JMenuItem, PlugIn> menuItemRegistry = new HashMap<JMenuItem, PlugIn>();
    static Pattern posPattern = Pattern.compile("^(.*)\\{(?:pos\\:)?(\\d+)\\}$");
    private static boolean separatingEnabled = false;

    private FeatureInstaller(WorkbenchContext workbenchContext) {
        this.workbenchContext = workbenchContext;
        this.checkFactory = EnableCheckFactory.getInstance(workbenchContext);
    }

    public static FeatureInstaller getInstance(WorkbenchContext context) {
        FeatureInstaller instance = instances.get(context);
        if (instance == null) {
            instance = new FeatureInstaller(context);
            instances.put(context, instance);
        }
        return instance;
    }

    public MultiEnableCheck createLayersSelectedCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(this.checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    public MultiEnableCheck createOneLayerSelectedCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(this.checkFactory.createExactlyNLayersMustBeSelectedCheck(1));
    }

    public MultiEnableCheck createVectorsExistCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createAtLeastNVectorsMustBeDrawnCheck(1));
    }

    public MultiEnableCheck createFenceExistsCheck() {
        return new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createFenceMustBeDrawnCheck());
    }

    public void addMenuSeparator(String menu) {
        this.addMenuSeparator(new String[]{menu});
    }

    public void addMenuSeparator(String[] menuPath) {
        JMenu mainMenu = this.menuBarMenu(menuPath[0]);
        this.createMenusIfNecessary(FeatureInstaller.wrapMenu(mainMenu), FeatureInstaller.behead(menuPath)).addSeparator();
    }

    public void addMenuSeparator(JMenu menu) {
        int pos = -1;
        int count = menu.getMenuComponentCount();
        if (menu.getText().equals(MenuNames.FILE) && (pos < 0 || pos >= count - 2)) {
            pos = count - 2;
        }
        if (pos < 0) {
            menu.addSeparator();
        } else {
            menu.insertSeparator(pos);
        }
    }

    public void addLayerViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String menuName, String menuItemName) {
        this.addLayerNameViewMenuItem(executable, new String[]{menuName}, menuItemName);
    }

    public void addLayerViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }

    public void addLayerNameViewMenuItem(PlugIn executable, String[] menuPath, String menuItemName) {
        this.addMainMenuItem(executable, menuPath, menuItemName, false, null, new MultiEnableCheck().add(this.checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(this.checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()));
    }

    public void addMainMenuItem(PlugIn executable, String menuName, String menuItemName, Icon icon, EnableCheck enableCheck) {
        this.addMainMenuPlugin(executable, new String[]{menuItemName}, menuItemName, false, icon, enableCheck);
    }

    public JMenu addMainMenu(String[] menuPath, String menuName) {
        if (menuPath == null) {
            throw new IllegalArgumentException("menuPath must be a string array");
        }
        JMenuBar parent = this.menuBar();
        ArrayList<String> fullPathList = new ArrayList<String>(Arrays.asList(menuPath));
        fullPathList.add(menuName);
        Menu subMenu = this.createMenusIfNecessary(FeatureInstaller.wrapMenu(parent), fullPathList.toArray(new String[0]));
        return (JMenu)subMenu.getWrappee();
    }

    public JMenuItem addMainMenuPlugin(PlugIn executable, String[] menuPath) {
        return this.addMainMenuPlugin(executable, menuPath, executable.getName(), false, null, null, -1);
    }

    public JMenuItem addMainMenuPlugin(PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        return this.addMainMenuPlugin(executable, menuPath, menuItemName, checkBox, icon, enableCheck, -1);
    }

    public JMenuItem addMainMenuPlugin(PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck, int pos) {
        WorkbenchProperties wbProps = this.workbenchContext.getWorkbench().getProperties();
        String checkboxSetting = wbProps.getSetting(new String[]{"plug-in", executable.getClass().getName(), "menus", "main-menu", "checkbox"});
        if (checkboxSetting.equals("true")) {
            checkBox = true;
        }
        JMenuItem menuItem = this.createMenuItem(menuItemName, checkBox, icon);
        menuItem = this.addMainMenuPluginItemWithPostProcessing(executable, menuPath, menuItem, icon, enableCheck, pos);
        return menuItem;
    }

    private JMenuItem addMainMenuPluginItemWithPostProcessing(PlugIn executable, String[] menuPath, JMenuItem menuItem, Icon icon, EnableCheck enableCheck, int pos) {
        if (executable instanceof CheckBoxed && !(menuItem instanceof JCheckBoxMenuItem)) {
            menuItem = this.createMenuItem(menuItem.getText(), true, icon);
        }
        this.addMenuPluginItem(FeatureInstaller.wrapMenu(this.menuBar()), executable, menuPath, menuItem, icon, enableCheck);
        return menuItem;
    }

    public JMenuItem addMenuPlugin(String menuKey, PlugIn plugin) {
        String checkBoxSetting;
        Menu menu = this.fetchMenuForKey(menuKey);
        if (menu == null) {
            throw new IllegalArgumentException("Menu key '" + menuKey + "' does not point to a known menu.");
        }
        boolean checkBox = false;
        if (plugin instanceof CheckBoxed) {
            checkBox = true;
        }
        if ((checkBoxSetting = this.fetchPluginMenuSetting(menu.getWrappee(), plugin, "checkbox")).equals("true")) {
            checkBox = true;
        }
        JMenuItem menuItem = this.createMenuItem(plugin.getName(), checkBox, null);
        return this.addMenuPluginItem(menu, plugin, new String[0], menuItem, null, null);
    }

    private JMenuItem addMenuPluginItem(Menu menu, PlugIn plugin, String[] menuPath, JMenuItem menuItem, Icon icon, EnableCheck enableCheck) {
        List<String> posListFromProps;
        String name;
        String iconSetting = this.fetchPluginMenuSetting(menu.getWrappee(), plugin, "icon");
        if (!iconSetting.isEmpty()) {
            icon = IconLoader.icon(iconSetting);
        }
        if ((name = menuItem.getText()) == null || name.trim().equals("")) {
            Logger.error("plugin '" + plugin.getClass().getCanonicalName() + "' does provide an invalid _empty_ menu item name. it will be installed with it's classname instead!");
            menuItem.setText(plugin.getClass().getSimpleName());
        }
        if (icon instanceof ImageIcon && icon.getIconHeight() > 16) {
            icon = GUIUtil.resize((ImageIcon)icon, 16);
        }
        this.addMenuItemIcon(menuItem, icon == null && plugin instanceof Iconified ? ((Iconified)((Object)plugin)).getIcon(16) : icon);
        this.assignShortcut(menuItem, plugin);
        String nameSetting = this.fetchPluginMenuSetting(menu.getWrappee(), plugin, "name");
        if (!nameSetting.isEmpty()) {
            menuItem.setText(this.computeName(nameSetting));
        } else if (menuItem.getText().trim().length() == 0) {
            menuItem.setText(plugin.getName());
        }
        Matcher m = posPattern.matcher(menuItem.getText().trim());
        if (m.matches()) {
            menuItem.setText(m.toMatchResult().group(1));
        }
        String pathSetting = this.fetchPluginMenuSetting(menu.getWrappee(), plugin, "menupath");
        Object[] menuPathPositions = new String[menuPath.length];
        if (!pathSetting.isEmpty()) {
            menuPath = pathSetting.split("/");
            menuPathPositions = new String[menuPath.length];
            for (int i = 0; i < menuPath.length; ++i) {
                String pathEntry = menuPath[i].trim();
                m = posPattern.matcher(pathEntry);
                if (m.matches()) {
                    MatchResult mr = m.toMatchResult();
                    menuPath[i] = pathEntry = mr.group(1);
                    menuPathPositions[i] = mr.group(2);
                }
                menuPath[i] = this.computeName(pathEntry);
            }
        }
        if ((posListFromProps = this.calculateNewPosition(menu, new ArrayList<String>(Arrays.asList(menuPath)), menu, plugin)).size() > 0) {
            menuPathPositions = new String[menuPath.length + 1];
            for (int i = 0; i < menuPathPositions.length && i < posListFromProps.size(); ++i) {
                menuPathPositions[i] = posListFromProps.get(i);
            }
        }
        this.associate(menuItem, plugin);
        Menu itemRoot = this.createMenusIfNecessary(menu, menuPath, menuPathPositions);
        List<String> posList = this.calculateNewPosition(menu, new ArrayList(), itemRoot, plugin);
        int pos = posList.isEmpty() ? -1 : Integer.parseInt(posList.get(0).toString());
        FeatureInstaller.installMnemonic(menuItem, (MenuElement)((Object)itemRoot.getWrappee()));
        int count = itemRoot.getComponentCount();
        if (itemRoot.getWrappee() == this.menuBarMenu(MenuNames.FILE) && (pos < 0 || pos >= count - 2)) {
            pos = count - 2;
        } else if (pos < 2 && itemRoot instanceof TitledPopupMenu) {
            pos = 2;
        }
        if (pos < 0) {
            itemRoot.add(menuItem);
        } else {
            itemRoot.insert(menuItem, pos);
        }
        if (this.isSeparatingEnabled()) {
            this.updateSeparatorsFromProps(menu, menu);
        }
        EnableCheck enableCheck2 = enableCheck = enableCheck == null && plugin instanceof EnableChecked ? ((EnableChecked)((Object)plugin)).getEnableCheck() : enableCheck;
        if (enableCheck != null) {
            if (menu.getWrappee() instanceof JPopupMenu) {
                final JMenuItem item = menuItem;
                final EnableCheck check = enableCheck;
                ((JPopupMenu)menu.getWrappee()).addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        FeatureInstaller.this.toMenuItemShownListener(check).menuItemShown(item);
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
            } else {
                this.addMenuItemShownListener(menuItem, this.toMenuItemShownListener(enableCheck));
            }
        }
        return menuItem;
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin) {
        return this.addMainMenuPlugin(plugin, menuPath);
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin, int pos) {
        return this.addMainMenuPlugin(plugin, menuPath, plugin.getName(), false, plugin.getIcon(), plugin.getEnableCheck(), pos);
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin, EnableCheck enableCheck) {
        return this.addMainMenuPlugin(plugin, menuPath, plugin.getName(), false, plugin.getIcon(), enableCheck);
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin, EnableCheck enableCheck, int pos) {
        return this.addMainMenuPlugin(plugin, menuPath, plugin.getName(), false, plugin.getIcon(), enableCheck, pos);
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin, JMenuItem menuItem, int pos) {
        return this.addMainMenuPluginItemWithPostProcessing(plugin, menuPath, menuItem, null, null, pos);
    }

    public JMenuItem addMainMenuItem(String[] menuPath, AbstractUiPlugIn plugin, JMenuItem menuItem, EnableCheck enableCheck, int pos) {
        return this.addMainMenuPluginItemWithPostProcessing(plugin, menuPath, menuItem, null, enableCheck, pos);
    }

    public void addMainMenuItem(PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        int pos = -1;
        this.addMainMenuPlugin(executable, menuPath, menuItemName, checkBox, icon, enableCheck, pos);
    }

    public JMenuItem addMainMenuItem(PlugIn plugin, String[] menuPath, JMenuItem menuItem, EnableCheck enableCheck) {
        return this.addMainMenuPluginItemWithPostProcessing(plugin, menuPath, menuItem, null, enableCheck, -1);
    }

    public JMenuItem addMainMenuItem(PlugIn plugin, String[] menuPath, JMenuItem menuItem, EnableCheck enableCheck, int pos) {
        return this.addMainMenuPluginItemWithPostProcessing(plugin, menuPath, menuItem, null, enableCheck, pos);
    }

    private MenuItemShownListener toMenuItemShownListener(EnableCheck enableCheck) {
        return new EnableCheckMenuItemShownListener(this.workbenchContext, enableCheck);
    }

    public void addMenuItemShownListener(JMenuItem menuItem, MenuItemShownListener menuItemShownListener) {
        JMenu menu = (JMenu)((JPopupMenu)menuItem.getParent()).getInvoker();
        menu.addMenuListener(new JumpMenuListener(menuItemShownListener, menuItem));
    }

    public JMenuItem addPopupMenuPlugin(JPopupMenu popupMenu, PlugIn executable) {
        return this.addPopupMenuPlugin(popupMenu, executable, new String[0], null, false, null, null);
    }

    public JMenuItem addPopupMenuPlugin(JPopupMenu popupMenu, PlugIn executable, String[] menuPath) {
        return this.addPopupMenuPlugin(popupMenu, executable, menuPath, null, false, null, null);
    }

    public JMenuItem addPopupMenuPlugin(JPopupMenu popupMenu, PlugIn executable, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        return this.addPopupMenuPlugin(popupMenu, executable, new String[0], menuItemName, checkBox, icon, enableCheck);
    }

    public JMenuItem addPopupMenuPlugin(JPopupMenu popupMenu, PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        checkBox = checkBox || executable instanceof CheckBoxed;
        JMenuItem menuItem = this.createMenuItem(menuItemName, checkBox, icon);
        return this.addMenuPluginItem(FeatureInstaller.wrapMenu(popupMenu), executable, menuPath, menuItem, icon, enableCheck);
    }

    public void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        this.addPopupMenuPlugin(popupMenu, executable, menuItemName, checkBox, icon, enableCheck);
    }

    public void addPopupMenuItem(JPopupMenu popupMenu, PlugIn executable, String[] menuPath, String menuItemName, boolean checkBox, Icon icon, EnableCheck enableCheck) {
        this.addPopupMenuPlugin(popupMenu, executable, menuPath, menuItemName, checkBox, icon, enableCheck);
    }

    public boolean isSeparatingEnabled() {
        return separatingEnabled;
    }

    public void setSeparatingEnabled(boolean onoff) {
        separatingEnabled = onoff;
    }

    public void updateSeparatorsInAllMenus() {
        for (Menu menu : this.getAllMenus()) {
            this.updateSeparatorsFromProps(menu, menu);
        }
    }

    private void updateSeparatorsFromProps(Menu menuRoot, Menu menuWrap) {
        WorkbenchProperties wbProps = this.workbenchContext.getWorkbench().getProperties();
        int count = menuWrap.getComponentCount();
        block0: for (int i = 0; i < count; ++i) {
            Component c1 = menuWrap.getComponent(i);
            int item1Pos = -1;
            if (c1 instanceof JMenu) {
                item1Pos = this.getHighestMenuItemPositionRecursive(menuRoot, FeatureInstaller.wrapMenu((JMenu)c1));
                this.updateSeparatorsFromProps(menuRoot, FeatureInstaller.wrapMenu((JMenu)c1));
            } else {
                PlugIn p1;
                if (!(c1 instanceof JMenuItem) || (p1 = this.pluginFromMenuItem((JMenuItem)c1)) == null) continue;
                String posSetting = this.fetchPluginMenuSetting(menuRoot.getWrappee(), p1, "order_id");
                int n = item1Pos = posSetting.isEmpty() ? -1 : Integer.parseInt(posSetting);
            }
            if (item1Pos < 0) continue;
            int item2Pos = -1;
            for (int j = i + 1; j < menuWrap.getComponentCount(); ++j) {
                Component c2 = menuWrap.getComponent(j);
                if (c2 instanceof JMenu) {
                    item2Pos = this.getLowestMenuItemPositionRecursive(menuRoot, FeatureInstaller.wrapMenu((JMenu)c2));
                } else if (c2 instanceof JMenuItem) {
                    PlugIn p2 = this.pluginFromMenuItem((JMenuItem)c2);
                    if (p2 == null) continue;
                    String posSetting = this.fetchPluginMenuSetting(menuRoot.getWrappee(), p2, "order_id");
                    item2Pos = posSetting.isEmpty() ? -1 : Integer.parseInt(posSetting);
                } else if (c2 instanceof JPopupMenu.Separator) break;
                if (item2Pos >= 0) break;
            }
            if (item2Pos < 0) continue;
            Map sepList = wbProps.getSettings(new String[]{"separator"});
            for (Map attribs : sepList.values()) {
                Object sepPosSetting = attribs.get("order_id");
                int sepPos = sepPosSetting == null ? -1 : Integer.parseInt(sepPosSetting.toString());
                if (sepPos <= item1Pos || sepPos >= item2Pos || menuWrap.getWrappee() instanceof JMenuBar) continue;
                menuWrap.insertSeparator(i + 1);
                ++count;
                continue block0;
            }
        }
    }

    private int getHighestMenuItemPositionRecursive(Menu root, Menu menu) {
        int pos = -1;
        for (int j = 0; j < menu.getComponentCount(); ++j) {
            PlugIn p;
            Component c = menu.getComponent(j);
            if (c instanceof JMenu) {
                int subPos = this.getHighestMenuItemPositionRecursive(root, FeatureInstaller.wrapMenu((JMenu)c));
                pos = subPos > pos ? subPos : pos;
                continue;
            }
            if (!(c instanceof JMenuItem) || !((p = this.pluginFromMenuItem((JMenuItem)c)) instanceof PlugIn)) continue;
            String posSetting = this.fetchPluginMenuSetting(root.getWrappee(), p, "order_id");
            int subPos = posSetting.isEmpty() ? -1 : Integer.parseInt(posSetting);
            pos = subPos > pos ? subPos : pos;
        }
        return pos;
    }

    private int getLowestMenuItemPositionRecursive(Menu root, Menu menu) {
        int pos = -1;
        for (int j = 0; j < menu.getComponentCount(); ++j) {
            String posSetting;
            PlugIn p;
            Component c = menu.getComponent(j);
            int subPos = -1;
            if (c instanceof JMenu) {
                subPos = this.getLowestMenuItemPositionRecursive(root, FeatureInstaller.wrapMenu((JMenu)c));
            } else if (c instanceof JMenuItem && (p = this.pluginFromMenuItem((JMenuItem)c)) instanceof PlugIn && !(posSetting = this.fetchPluginMenuSetting(root.getWrappee(), p, "order_id")).isEmpty()) {
                subPos = Integer.parseInt(posSetting);
            }
            if (subPos < 0 || pos >= 0 && subPos >= pos) continue;
            pos = subPos;
        }
        return pos;
    }

    private List<String> calculateNewPosition(Menu parent, List menuPath, Menu menu, PlugIn p) {
        int pluginPos;
        WorkbenchProperties wbProps = this.workbenchContext.getWorkbench().getProperties();
        String posSetting = this.fetchPluginMenuSetting(parent.getWrappee(), p, "order_id");
        int n = pluginPos = posSetting.isEmpty() ? -1 : Integer.parseInt(posSetting);
        if (pluginPos < 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> computedPosList = new ArrayList<String>();
        int lastPos = -1;
        int itemPos = -1;
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component c = menu.getComponent(i);
            if (c instanceof JMenu) {
                List<String> computedPosSubList;
                ArrayList menuSubPath = new ArrayList(menuPath);
                if (!menuSubPath.isEmpty()) {
                    menuSubPath.remove(0);
                }
                if ((computedPosSubList = this.calculateNewPosition(parent, menuSubPath, FeatureInstaller.wrapMenu((JMenu)c), p)).size() > 0) {
                    boolean foundSeparators = false;
                    for (int j = lastPos; lastPos >= 0 && j < i; ++j) {
                        if (!(menu.getComponent(j) instanceof JPopupMenu.Separator)) continue;
                        foundSeparators = true;
                        break;
                    }
                    computedPosList.add(Integer.toString(foundSeparators ? lastPos + 1 : i));
                    computedPosList.addAll(computedPosSubList);
                    break;
                }
                if (!menuPath.isEmpty() && ((JMenu)c).getText().equals(menuPath.get(0))) {
                    break;
                }
            } else {
                PlugIn p2 = this.pluginFromMenuItem(c);
                if (p2 == null) continue;
                posSetting = this.fetchPluginMenuSetting(parent.getWrappee(), p2, "order_id");
                int n2 = itemPos = posSetting.isEmpty() ? -1 : Integer.parseInt(posSetting);
            }
            if (itemPos < 0) continue;
            if (itemPos > pluginPos) {
                boolean isConfigSeparated = false;
                Map sepList = wbProps.getSettings(new String[]{"separator"});
                for (Map attribs : sepList.values()) {
                    Object sepPosSetting = attribs.get("order_id");
                    int sepPos = sepPosSetting == null ? -1 : Integer.parseInt(sepPosSetting.toString());
                    if (sepPos <= pluginPos || sepPos >= itemPos) continue;
                    isConfigSeparated = true;
                    break;
                }
                boolean foundSeparators = false;
                for (int j = lastPos; lastPos >= 0 && j < i; ++j) {
                    if (!(menu.getComponent(j) instanceof JPopupMenu.Separator)) continue;
                    foundSeparators = true;
                    break;
                }
                int pos = foundSeparators && isConfigSeparated ? lastPos + 1 : i;
                computedPosList.add(0, Integer.toString(pos));
                break;
            }
            lastPos = i;
        }
        return computedPosList;
    }

    public String fetchKeyForMenu(Object menu) {
        String menuKey = "";
        if (menu == this.menuBar()) {
            menuKey = "main-menu";
        } else if (menu == this.workbenchContext.getWorkbench().getFrame().getCategoryPopupMenu()) {
            menuKey = "category-popup";
        } else if (menu == this.workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu()) {
            menuKey = "layername-popup";
        } else if (menu == LayerViewPanel.popupMenu()) {
            menuKey = "layerview-popup";
        } else if (menu == this.workbenchContext.getWorkbench().getFrame().getWMSLayerNamePopupMenu()) {
            menuKey = "layername-popup-wms";
        } else if (menu == AttributeTab.popupMenu(this.workbenchContext)) {
            menuKey = "attributetab-popup";
        } else if (menu == RasterImageContextMenu.getInstance(this.workbenchContext.createPlugInContext())) {
            menuKey = "layername-popup-raster";
        } else if (menu instanceof JMenu) {
            menuKey = ((JMenu)menu).getText();
        }
        return menuKey;
    }

    public Menu fetchMenuForKey(String key) {
        Menu menu = null;
        if (key.equals("main-menu")) {
            menu = FeatureInstaller.wrapMenu(this.menuBar());
        } else if (key.equals("category-popup")) {
            menu = FeatureInstaller.wrapMenu(this.workbenchContext.getWorkbench().getFrame().getCategoryPopupMenu());
        } else if (key.equals("layername-popup")) {
            menu = FeatureInstaller.wrapMenu(this.workbenchContext.getWorkbench().getFrame().getLayerNamePopupMenu());
        } else if (key.equals("layerview-popup")) {
            menu = FeatureInstaller.wrapMenu(LayerViewPanel.popupMenu());
        } else if (key.equals("layername-popup-wms")) {
            menu = FeatureInstaller.wrapMenu(this.workbenchContext.getWorkbench().getFrame().getWMSLayerNamePopupMenu());
        } else if (key.equals("attributetab-popup")) {
            menu = FeatureInstaller.wrapMenu(AttributeTab.popupMenu(this.workbenchContext));
        } else if (key.equals("layername-popup-raster")) {
            menu = FeatureInstaller.wrapMenu(RasterImageContextMenu.getInstance(this.workbenchContext.createPlugInContext()));
        }
        return menu;
    }

    private List<Menu> getAllMenus() {
        Vector<Menu> menus = new Vector<Menu>();
        String[] keys = new String[]{"main-menu", "category-popup", "layername-popup", "layerview-popup", "layername-popup-wms", "attributetab-popup", "layername-popup-raster"};
        for (int i = 0; i < keys.length; ++i) {
            menus.add(this.fetchMenuForKey(keys[i]));
        }
        return menus;
    }

    private String fetchPluginMenuSetting(Object menu, PlugIn plugin, String attribute_key) {
        String menu_key = this.fetchKeyForMenu(menu);
        if (menu_key.isEmpty()) {
            return "";
        }
        WorkbenchProperties wbProps = this.workbenchContext.getWorkbench().getProperties();
        String setting = wbProps.getSetting(new String[]{"plug-in", plugin.getClass().getName(), "menus", menu_key, attribute_key});
        if (setting.isEmpty() && attribute_key.equals("order_id")) {
            setting = wbProps.getSetting(new String[]{"plug-in", plugin.getClass().getName(), attribute_key});
        }
        return setting;
    }

    private int getPositionFromList(List<String> list, String key) {
        int i = 0;
        for (String string : list) {
            if (string.equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List getMenuListFromSettings(Object menu) {
        String menuKey = this.fetchKeyForMenu(menu);
        if (menuKey.isEmpty()) {
            return new ArrayList();
        }
        WorkbenchProperties wbProps = this.workbenchContext.getWorkbench().getProperties();
        return wbProps.getSettingsList(new String[]{"layout", menuKey, "list"});
    }

    public void addPopupMenuSeparator(JPopupMenu popupMenu, String[] menuPath) {
        if (menuPath == null || menuPath.length == 0) {
            popupMenu.addSeparator();
        } else {
            JMenu menu = FeatureInstaller.popupMenu(popupMenu, menuPath[0]);
            if (menu == null) {
                menu = (JMenu)popupMenu.add(new JMenu(menuPath[0]));
            }
            Menu parent = this.createMenusIfNecessary(FeatureInstaller.wrapMenu(menu), FeatureInstaller.behead(menuPath));
            parent.addSeparator();
        }
    }

    public static JMenu popupMenu(JPopupMenu popupMenu, String childName) {
        MenuElement[] subElements = popupMenu.getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            JMenuItem menuItem;
            if (!(subElements[i] instanceof JMenuItem) || !(menuItem = (JMenuItem)subElements[i]).getText().equals(childName)) continue;
            return (JMenu)menuItem;
        }
        return null;
    }

    public static Menu wrapMenu(final JPopupMenu popupMenu) {
        return new Menu(){

            @Override
            public void insert(JMenuItem menuItem, int i) {
                popupMenu.insert(menuItem, i);
            }

            @Override
            public String getText() {
                return "";
            }

            @Override
            public int getComponentCount() {
                return popupMenu.getComponentCount();
            }

            @Override
            public void add(JMenuItem menuItem) {
                popupMenu.add(menuItem);
            }

            @Override
            public Component getComponent(int i) {
                return popupMenu.getComponent(i);
            }

            @Override
            public JComponent getWrappee() {
                return popupMenu;
            }

            @Override
            public void addSeparator() {
                popupMenu.addSeparator();
            }

            @Override
            public void insertSeparator(int i) {
                popupMenu.insert(new JPopupMenu.Separator(), i);
            }

            @Override
            public void remove(int i) {
                popupMenu.remove(i);
            }
        };
    }

    public static Menu wrapMenu(final JMenu menu) {
        return new Menu(){

            @Override
            public void insert(JMenuItem menuItem, int i) {
                menu.insert(menuItem, i);
            }

            @Override
            public String getText() {
                return menu.getText();
            }

            @Override
            public int getComponentCount() {
                return menu.getMenuComponentCount();
            }

            @Override
            public void add(JMenuItem menuItem) {
                menu.add(menuItem);
            }

            @Override
            public Component getComponent(int i) {
                return menu.getMenuComponent(i);
            }

            @Override
            public JComponent getWrappee() {
                return menu;
            }

            @Override
            public void addSeparator() {
                menu.addSeparator();
            }

            @Override
            public void insertSeparator(int i) {
                menu.insertSeparator(i);
            }

            @Override
            public void remove(int i) {
                menu.remove(i);
            }
        };
    }

    public static Menu wrapMenu(final JMenuBar menu) {
        return new Menu(){

            @Override
            public String getText() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getComponentCount() {
                return menu.getMenuCount();
            }

            @Override
            public Component getComponent(int i) {
                return menu.getMenu(i);
            }

            @Override
            public void add(JMenuItem menuItem) {
                menu.add((JMenu)menuItem);
            }

            @Override
            public void insert(JMenuItem menuItem, int i) {
                menu.add((Component)menuItem, i);
            }

            @Override
            public JComponent getWrappee() {
                return menu;
            }

            @Override
            public void addSeparator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void insertSeparator(int i) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(int i) {
                menu.remove(i);
            }
        };
    }

    public JMenuBar menuBar() {
        return this.workbenchContext.getWorkbench().getFrame().getJMenuBar();
    }

    public JMenu menuBarMenu(String childName) {
        MenuElement[] subElements = this.menuBar().getSubElements();
        for (int i = 0; i < subElements.length; ++i) {
            JMenuItem menuItem;
            if (!(subElements[i] instanceof JMenuItem) || !(menuItem = (JMenuItem)subElements[i]).getText().equals(childName)) continue;
            return (JMenu)menuItem;
        }
        return null;
    }

    public Menu createMenusIfNecessary(Menu parent, String[] menuPath) {
        return this.createMenusIfNecessary(parent, menuPath, new String[menuPath.length]);
    }

    public Menu createMenusIfNecessary(Menu parent, String[] menuPath, Object[] menuPathPositions) {
        JMenu child;
        if (menuPath == null || menuPath.length == 0) {
            return parent;
        }
        if (menuPath[0].equals(MenuNames.ZOOM) && this.fetchKeyForMenu(parent.getWrappee()).equals("layerview-popup")) {
            System.out.println();
        }
        if ((child = (JMenu)FeatureInstaller.childMenuItem(menuPath[0], parent)) == null) {
            child = (JMenu)FeatureInstaller.installMnemonic(new JMenu(menuPath[0]), (MenuElement)((Object)parent.getWrappee()));
            int pos = -1;
            if (menuPathPositions != null && menuPathPositions.length > 0) {
                try {
                    pos = Integer.parseInt(menuPathPositions[0].toString());
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            int count = parent.getComponentCount();
            if (parent.getWrappee() == this.menuBarMenu(MenuNames.FILE) && (pos < 0 || pos >= count - 2)) {
                pos = count - 2;
            } else if (parent.getWrappee() == this.menuBar() && !child.getText().equals(MenuNames.HELP) && !child.getText().equals(MenuNames.WINDOW)) {
                Menu menu = FeatureInstaller.wrapMenu(this.menuBar());
                for (int i = 0; i < menu.getComponentCount(); ++i) {
                    Component c = menu.getComponent(i);
                    if (!(c instanceof JMenu)) continue;
                    String name = ((JMenu)c).getText();
                    if (pos <= i && pos >= 0 || !name.equals(MenuNames.WINDOW) && !name.equals(MenuNames.HELP)) continue;
                    pos = i;
                    break;
                }
            }
            if (pos < 0) {
                parent.add(child);
            } else {
                parent.insert(child, pos);
            }
        }
        return this.createMenusIfNecessary(FeatureInstaller.wrapMenu(child), FeatureInstaller.behead(menuPath), FeatureInstaller.behead(menuPathPositions));
    }

    public static JMenuItem childMenuItem(String childName, Menu menu) {
        if (menu.getWrappee() instanceof JMenu) {
            Menu popup = FeatureInstaller.wrapMenu(((JMenu)menu.getWrappee()).getPopupMenu());
            return FeatureInstaller.childMenuItem(childName, popup);
        }
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component c = menu.getComponent(i);
            if (!(c instanceof JMenuItem) || !((JMenuItem)c).getText().equals(childName)) continue;
            return (JMenuItem)c;
        }
        return null;
    }

    public static JMenuItem childMenuItem(String itemName, Menu menu, String[] menuPath) {
        for (String pathName : menuPath) {
            JMenuItem item = FeatureInstaller.childMenuItem(pathName, menu);
            if (item == null || !(item instanceof JMenu)) {
                return null;
            }
            menu = FeatureInstaller.wrapMenu((JMenu)item);
        }
        return FeatureInstaller.childMenuItem(itemName, menu);
    }

    private static String[] strip(String[] a1) {
        String[] a2 = new String[a1.length - 1];
        System.arraycopy(a1, 0, a2, 0, a2.length);
        return a2;
    }

    private static String[] behead(String[] a1) {
        String[] a2 = new String[a1.length - 1];
        System.arraycopy(a1, 1, a2, 0, a2.length);
        return a2;
    }

    private static Object[] behead(Object[] a1) {
        Object[] a2 = new Object[a1.length - 1];
        System.arraycopy(a1, 1, a2, 0, a2.length);
        return a2;
    }

    private String computeName(String name) {
        if (name.startsWith("MenuNames.")) {
            try {
                Field field = MenuNames.class.getDeclaredField(name.replaceFirst("MenuNames\\.", ""));
                name = field.get(MenuNames.class.newInstance()).toString();
            }
            catch (Exception exception) {}
        } else if (name.startsWith("I18N.")) {
            name = I18N.getInstance().get(name.replaceFirst("I18N\\.", ""));
        }
        return name;
    }

    private ActionListener abstractPlugInActionListener(ActionListener[] actionListeners) {
        for (int i = 0; i < actionListeners.length; ++i) {
            if (actionListeners[i].getClass().getName().indexOf(AbstractPlugIn.class.getName()) <= -1) continue;
            return actionListeners[i];
        }
        Assert.shouldNeverReachHere();
        return null;
    }

    private void assignShortcut(JMenuItem menuItem, PlugIn executable) {
        if (executable instanceof ShortcutEnabled) {
            ShortcutEnabled shortCutPlugin = (ShortcutEnabled)((Object)executable);
            KeyStroke st = shortCutPlugin.getShortcutKeyStroke();
            if (st == null || st.getKeyCode() < 1) {
                return;
            }
            st = ShortcutPluginExecuteKeyListener.getPlatformKeyStroke(st);
            menuItem.setAccelerator(st);
            if (this.workbenchContext.getWorkbench().getFrame().getKeyboardShortcutPlugin(st) == null) {
                this.registerShortcuts(executable);
            }
        }
    }

    public boolean registerShortcuts(PlugIn plugin) {
        PlugIn[] shortys = FeatureInstaller.fetchShortcutEnabledPlugins(plugin);
        if (shortys.length < 1) {
            return false;
        }
        WorkbenchFrame f = this.workbenchContext.getWorkbench().getFrame();
        for (PlugIn p : shortys) {
            Assert.isTrue((boolean)(p instanceof ShortcutEnabled), (String)"plugin must be shortcut enabled");
            KeyStroke st = ((ShortcutEnabled)((Object)p)).getShortcutKeyStroke();
            if (this.workbenchContext.getWorkbench().getFrame().getKeyboardShortcutPlugin(st) != null) continue;
            f.addKeyboardShortcut(st, p);
        }
        return true;
    }

    public static PlugIn[] fetchShortcutEnabledPlugins(PlugIn plugin) {
        PlugIn[] shortys;
        Vector<PlugIn> plugins = new Vector<PlugIn>();
        if (plugin instanceof ShortcutEnabled && ((ShortcutEnabled)((Object)plugin)).isShortcutEnabled()) {
            plugins.add(plugin);
        }
        if (plugin instanceof MultiShortcutEnabled && (shortys = ((MultiShortcutEnabled)((Object)plugin)).getShortcutEnabledPlugins()) != null) {
            plugins.addAll(Arrays.asList(shortys));
        }
        return plugins.toArray(new PlugIn[0]);
    }

    private JMenuItem createMenuItem(String menuItemName, boolean checkBox, Icon icon) {
        JMenuItem item;
        if (checkBox) {
            JCheckBoxMenuItem cbi = new JCheckBoxMenuItem(menuItemName, icon){
                Icon def;
                ImageIcon sel;
                {
                    this.def = null;
                    this.sel = null;
                }

                @Override
                public void setSelected(boolean b) {
                    super.setSelected(b);
                    if (!FeatureInstaller.vista_checkbox_workaround()) {
                        if (this.def != null && this.getIcon() != this.def) {
                            this.setIcon(this.def);
                        }
                        return;
                    }
                    if (this.def == null) {
                        this.def = this.getIcon();
                    }
                    if (this.def instanceof ImageIcon) {
                        if (this.sel == null) {
                            this.sel = GUIUtil.overlay(GUIUtil.pad(GUIUtil.resize(GUIUtil.toImageIcon(this.getIcon()), 12), 0, 0, 4, 4), GUIUtil.resize(IconLoader.icon("famfam/tick.png"), 12), 4, 4);
                        }
                        this.setIcon(this.isSelected() ? this.sel : this.def);
                    }
                }
            };
            item = cbi;
        } else {
            item = new JMenuItem(menuItemName, icon);
        }
        return item;
    }

    private void associate(JMenuItem menuItem, PlugIn plugIn) {
        menuItem.addActionListener(AbstractPlugIn.toActionListener(plugIn, this.workbenchContext, this.taskMonitorManager));
        menuItemRegistry.put(menuItem, plugIn);
    }

    private PlugIn pluginFromMenuItem(Component menuItem) {
        return menuItemRegistry.get(menuItem);
    }

    private static boolean vista_checkbox_workaround() {
        boolean b = CheckOS.isWindows() && Float.valueOf(System.getProperty("os.version")).floatValue() >= 6.0f && UIManager.getLookAndFeel().getClass().getName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && UIManager.get("CheckBoxMenuItem.checkIconFactory") != null;
        return b;
    }

    private void addMenuItemIcon(JMenuItem menuItem, Icon icon) {
        if (FeatureInstaller.vista_checkbox_workaround() && menuItem instanceof JRadioButtonMenuItem) {
            return;
        }
        if (icon instanceof Icon) {
            menuItem.setIcon(icon);
        }
    }

    public static JMenuItem installMnemonic(JMenuItem menuItem, MenuElement parent) {
        String text = menuItem.getText();
        StringUtil.replaceAll(text, "&&", "##");
        int ampersandPosition = text.indexOf(38);
        if (-1 < ampersandPosition && ampersandPosition + 1 < text.length()) {
            menuItem.setMnemonic(text.charAt(ampersandPosition + 1));
            text = StringUtil.replace(text, "&", "", false);
        } else {
            FeatureInstaller.installDefaultMnemonic(menuItem, parent);
        }
        StringUtil.replaceAll(text, "##", "&");
        menuItem.setText(text);
        return menuItem;
    }

    private static void installDefaultMnemonic(JMenuItem menuItem, MenuElement parent) {
        block0: for (int i = 0; i < menuItem.getText().length(); ++i) {
            char candidate = Character.toUpperCase(menuItem.getText().charAt(i));
            if (!Character.isLetter(candidate)) continue;
            for (JMenuItem other : FeatureInstaller.menuItems(parent)) {
                if (other.getMnemonic() != candidate) continue;
                continue block0;
            }
            menuItem.setMnemonic(candidate);
            return;
        }
        menuItem.setMnemonic(menuItem.getText().charAt(0));
    }

    private static Collection menuItems(MenuElement element) {
        ArrayList<MenuElement> menuItems = new ArrayList<MenuElement>();
        if (element instanceof JMenuBar) {
            for (int i = 0; i < ((JMenuBar)element).getMenuCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenuBar)element).getMenu(i), menuItems);
            }
        } else if (element instanceof JMenu) {
            for (int i = 0; i < ((JMenu)element).getItemCount(); ++i) {
                CollectionUtil.addIfNotNull(((JMenu)element).getItem(i), menuItems);
            }
        } else if (element instanceof JPopupMenu) {
            MenuElement[] children = ((JPopupMenu)element).getSubElements();
            for (int i = 0; i < children.length; ++i) {
                if (!(children[i] instanceof JMenuItem)) continue;
                menuItems.add(children[i]);
            }
        } else {
            Assert.shouldNeverReachHere((String)element.getClass().getName());
        }
        return menuItems;
    }

    public class JumpMenuListener
    implements MenuListener {
        MenuItemShownListener menuItemShownListener;
        JMenuItem menuItem;

        public JumpMenuListener(MenuItemShownListener menuItemShownListener, JMenuItem menuItem) {
            this.menuItemShownListener = menuItemShownListener;
            this.menuItem = menuItem;
        }

        @Override
        public void menuSelected(MenuEvent e) {
            this.menuItemShownListener.menuItemShown(this.menuItem);
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }
    }

    public static interface Menu {
        public void add(JMenuItem var1);

        public void insert(JMenuItem var1, int var2);

        public void remove(int var1);

        public String getText();

        public int getComponentCount();

        public Component getComponent(int var1);

        public JComponent getWrappee();

        public void addSeparator();

        public void insertSeparator(int var1);
    }
}

