/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.WorkbenchException;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.EnterWKTDialog;
import com.vividsolutions.jump.workbench.ui.plugin.WKTDisplayHelper;
import com.vividsolutions.jump.workbench.ui.plugin.WKTPlugIn;
import java.util.Arrays;
import javax.swing.ImageIcon;
import org.locationtech.jts.io.WKTWriter;
import org.openjump.core.ui.images.IconLoader;

public class EditSelectedFeaturePlugIn
extends WKTPlugIn {
    public static ImageIcon ICON = IconLoader.icon("view_edit_geometry.png");
    private Feature feature;
    private WKTDisplayHelper helper = new WKTDisplayHelper();

    @Override
    protected Layer layer(PlugInContext context) {
        return context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems().iterator().next();
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("ui.plugin.EditSelectedFeaturePlugIn.view-edit-selected-feature");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNFeaturesMustHaveSelectedItemsCheck(1));
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return this.execute(context, context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems().iterator().next(), true);
    }

    public boolean execute(PlugInContext context, Feature feature, boolean editable) throws Exception {
        this.feature = feature;
        this.reportNothingToUndoYet(context);
        return super.execute(context);
    }

    @Override
    protected void apply(String wkt, PlugInContext context) throws Exception {
        if (!this.layer(context).isEditable()) {
            return;
        }
        super.apply(wkt, context);
    }

    @Override
    protected void apply(FeatureCollection c, PlugInContext context) throws WorkbenchException {
        if (c.size() != 1) {
            throw new WorkbenchException(I18N.getInstance().get("ui.plugin.EditSelectedFeaturePlugIn.expected-1-feature-but-found") + " " + c.size());
        }
        EditTransaction transaction = new EditTransaction(Arrays.asList(this.feature), this.getName(), this.layer, this.isRollingBackInvalidEdits(context), false, context.getWorkbenchFrame());
        Feature newFeature = c.iterator().next();
        transaction.setGeometry(this.feature, newFeature.getGeometry());
        transaction.commit();
    }

    @Override
    protected EnterWKTDialog createDialog(PlugInContext context) {
        EnterWKTDialog d = super.createDialog(context);
        d.setTitle((this.layer(context).isEditable() ? I18N.getInstance().get("ui.plugin.EditSelectedFeaturePlugIn.edit") + " " : "") + I18N.getInstance().get("ui.plugin.EditSelectedFeaturePlugIn.feature") + " " + this.feature.getID() + " " + I18N.getInstance().get("ui.plugin.EditSelectedFeaturePlugIn.in") + " " + this.layer + (this.layer(context).isEditable() ? "" : " (" + I18N.getInstance().get("ui.plugin.EditSelectedFeaturePlugIn.layer-is-uneditable") + ")"));
        d.setEditable(this.layer(context).isEditable());
        d.setText(this.helper.format(new WKTWriter(3).write(this.feature.getGeometry())));
        return d;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }
}

