/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public abstract class ProgressMonitor
extends JPanel
implements TaskMonitor {
    private final Component component;

    public ProgressMonitor(Component component) {
        this.component = component;
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.setOpaque(false);
    }

    protected Component getComponent() {
        return this.component;
    }

    protected abstract void addText(String var1);

    @Override
    public void report(String description) {
        this.addText(description);
    }

    @Override
    public void report(int itemsDone, int totalItems, String itemDescription) {
        this.addText(itemsDone + " / " + totalItems + " " + itemDescription);
    }

    @Override
    public void report(Exception exception) {
        this.addText(StringUtil.toFriendlyName(exception.getClass().getName()));
    }

    @Override
    public void allowCancellationRequests() {
    }

    @Override
    public boolean isCancelRequested() {
        return false;
    }
}

