/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.workbench.plugin.Configuration;
import com.vividsolutions.jump.workbench.plugin.PlugInManager;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.InlineView;
import org.locationtech.jts.JTSVersion;

public class ExtensionsAboutPanel
extends JPanel {
    private JTextPane editorPane = new JTextPane();
    private PlugInManager plugInManager;

    public ExtensionsAboutPanel(PlugInManager plugInManager) {
        this.plugInManager = plugInManager;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void refresh() {
        StringBuffer sb = new StringBuffer();
        int width = 460;
        sb.append("<html><head></head><body style=\"white-space:normal; width:" + width + "px;\">");
        sb.append("<b>JTS " + JTSVersion.CURRENT_VERSION + "</b><br>");
        sb.append("<hr>");
        for (Configuration configuration : this.plugInManager.getConfigurations()) {
            String msg = PlugInManager.message(configuration);
            sb.append("<div><b>" + GUIUtil.escapeHTML(PlugInManager.name(configuration), false, false) + "</b> " + GUIUtil.escapeHTML(PlugInManager.version(configuration), false, false) + GUIUtil.escapeHTML(!msg.isEmpty() ? " -> " + msg : "", false, false) + "<br></div>");
        }
        sb.append("</body></html>");
        this.remove(this.editorPane);
        this.editorPane.setText(sb.toString());
        this.add(this.editorPane);
    }

    void jbInit() throws Exception {
        this.editorPane.setEditable(false);
        this.editorPane.setOpaque(false);
        this.editorPane.setText("jEditorPane1");
        this.editorPane.setContentType("text/html");
        this.editorPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        this.editorPane.setEditorKit(new HTMLEditorKit(){

            @Override
            public ViewFactory getViewFactory() {
                return new HTMLEditorKit.HTMLFactory(){

                    @Override
                    public View create(Element e) {
                        View v = super.create(e);
                        if (v instanceof InlineView) {
                            return new InlineView(e){
                                boolean nowrap;
                                {
                                    this.nowrap = false;
                                }

                                @Override
                                protected void setPropertiesFromAttributes() {
                                    super.setPropertiesFromAttributes();
                                    Object whitespace = this.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                                    this.nowrap = whitespace != null && whitespace.equals("nowrap");
                                }

                                @Override
                                public int getBreakWeight(int axis, float pos, float len) {
                                    if (this.nowrap) {
                                        return 0;
                                    }
                                    return super.getBreakWeight(axis, pos, len);
                                }
                            };
                        }
                        return v;
                    }
                };
            }
        });
        Font font = UIManager.getFont("Label.font");
        long fontSize = Math.round((double)font.getSize() * 1.1);
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + fontSize + "pt; }";
        ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        String divRule = "div { margin-top:" + Math.round(fontSize / 4L) + "pt; }";
        ((HTMLDocument)this.editorPane.getDocument()).getStyleSheet().addRule(divRule);
        this.add(this.editorPane);
    }
}

