/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.plugin;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.imagery.ReferencedImagesLayer;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.LayerNamePanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelProxy;
import com.vividsolutions.jump.workbench.ui.LayerableNamePanel;
import com.vividsolutions.jump.workbench.ui.SelectionManagerProxy;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.TaskFrameProxy;
import com.vividsolutions.jump.workbench.ui.warp.WarpingVectorLayerFinder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.locationtech.jts.util.Assert;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;

public class EnableCheckFactory {
    private final WorkbenchContext workbenchContext;
    private static Map<WorkbenchContext, EnableCheckFactory> instances = new HashMap<WorkbenchContext, EnableCheckFactory>();

    private EnableCheckFactory(WorkbenchContext workbenchContext) {
        Assert.isTrue((workbenchContext != null ? 1 : 0) != 0);
        this.workbenchContext = workbenchContext;
    }

    public static EnableCheckFactory getInstance(WorkbenchContext workbenchContext) {
        if (workbenchContext == null) {
            throw new IllegalArgumentException("workbenchContext must not be *null*");
        }
        EnableCheckFactory instance = instances.get(workbenchContext);
        if (instance == null) {
            instance = new EnableCheckFactory(workbenchContext);
            instances.put(workbenchContext, instance);
        }
        return instance;
    }

    public EnableCheck createTaskWindowMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrame) ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.A-Task-Window-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithSelectionManagerMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof SelectionManagerProxy) ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-selection-manager-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerManagerMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerManagerProxy) ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-manager-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithAssociatedTaskFrameMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof TaskFrameProxy) ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.A-window-with-an-associated-task-frame-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerNamePanelMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerNamePanelProxy) ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-name-panel-must-be-active") : null;
            }
        };
    }

    public EnableCheck createWindowWithLayerViewPanelMustBeActiveCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return !(EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame() instanceof LayerViewPanelProxy) ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.A-window-with-a-layer-view-panel-must-be-active") : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedFeaturesCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Layer> layersWithSelectedFeatures = ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeatureSelection().getLayersWithSelectedItems();
                return layersWithSelectedFeatures.size() > 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Only-one-layer-may-have-selected-features") : null;
            }
        };
    }

    public EnableCheck createOnlyOneLayerMayHaveSelectedItemsCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                Collection<Layer> layersWithSelectedItems = ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems();
                return layersWithSelectedItems.size() > 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Only-one-layer-may-have-selected-items") : null;
            }
        };
    }

    public EnableCheck createSelectedItemsLayersMustBeEditableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                for (Layer layer : ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems()) {
                    if (layer.isEditable()) continue;
                    return I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Selected-items-layers-must-be-editable", layer.getName());
                }
                return null;
            }
        };
    }

    public EnableCheck createExactlyNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-category-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-categories-must-be-selected", n);
                return n != EnableCheckFactory.this.workbenchContext.getLayerableNamePanel().getSelectedCategories().size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNLayerablesMustBeSelectedCheck(final int n, final Class layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerableNamePanel lnp = EnableCheckFactory.this.workbenchContext.getLayerableNamePanel();
                if (lnp instanceof LayerNamePanel && n == lnp.selectedNodes(layerableClass).size()) {
                    return null;
                }
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-layers-must-be-selected", n);
                return msg;
            }
        };
    }

    public EnableCheck createExactlyNLayersMustBeSelectedCheck(int n) {
        return this.createExactlyNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNCategoriesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-category-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-categories-must-be-selected", n);
                return n > EnableCheckFactory.this.workbenchContext.getLayerableNamePanel().getSelectedCategories().size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayerablesMustBeSelectedCheck(final int n, final Class layerableClass) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerableNamePanel layerNamePanel = EnableCheckFactory.this.workbenchContext.getLayerableNamePanel();
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-be-selected", n);
                return layerNamePanel == null || n > EnableCheckFactory.this.workbenchContext.getLayerableNamePanel().selectedNodes(layerableClass).size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustBeSelectedCheck(int n) {
        return this.createAtLeastNLayerablesMustBeSelectedCheck(n, Layer.class);
    }

    public EnableCheck createAtLeastNLayersMustBeEditableCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-be-editable") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-be-editable", n);
                return n > EnableCheckFactory.this.workbenchContext.getLayerManager().getEditableLayers().size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastOneVisibleLayersMustBeEditableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                for (Layer layer : EnableCheckFactory.this.workbenchContext.getLayerManager().getLayers()) {
                    if (!layer.isVisible() || !layer.isEditable()) continue;
                    return null;
                }
                return I18N.getInstance().get("plugin.EnableCheckFactory.at-least-one-visible-layer-must-be-editable");
            }
        };
    }

    public EnableCheck createExactlyOneSelectedLayerMustBeEditableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-selected-layer-must-be-editable");
                Layer[] layers = EnableCheckFactory.this.workbenchContext.getLayerableNamePanel().getSelectedLayers();
                int countSelectedEditable = 0;
                for (Layer layer : layers) {
                    if (!layer.isEditable()) continue;
                    ++countSelectedEditable;
                }
                return 1 != countSelectedEditable ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayerablesMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerManager layerManager = EnableCheckFactory.this.workbenchContext.getLayerManager();
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-layerables-must-exist") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-layerables-must-exist", n);
                return layerManager == null || n > layerManager.getLayerables(Layerable.class).size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerManager layerManager = EnableCheckFactory.this.workbenchContext.getLayerManager();
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-layer-must-exist") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-layers-must-exist", n);
                return layerManager == null || n > layerManager.size() ? msg : null;
            }
        };
    }

    public EnableCheck createAtMostNLayersMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-most-one-layer-must-exist") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-most-n-layers-must-exist", n);
                return n < EnableCheckFactory.this.workbenchContext.getLayerManager().size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNVectorsMustBeDrawnCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-vector-must-be-drawn") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-vectors-must-be-drawn", n);
                return n != EnableCheckFactory.this.vectorCount() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNVectorsMustBeDrawnCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-vector-must-be-drawn") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-vectors-must-be-drawn", n);
                return n > EnableCheckFactory.this.vectorCount() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-be-selected", n);
                JInternalFrame f = EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame();
                return f instanceof SelectionManagerProxy && n > ((SelectionManagerProxy)((Object)f)).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                JInternalFrame iFrame = EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame();
                int selected = 0;
                try {
                    selected = ((SelectionManagerProxy)((Object)iFrame)).getSelectionManager().getSelectedItems().size();
                }
                catch (Exception e) {
                    System.out.println("eat exception @ EnableCheckFactory.createAtLeastNItemsMustBeSelectedCheck(i) if a non taskframe(or child) is selected");
                }
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-item-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-items-must-be-selected", n);
                String retVal = iFrame == null || n > selected ? msg : null;
                return retVal;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-feature-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-features-must-be-selected", n);
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNItemsMustBeSelectedCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-item-must-be-selected") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-items-must-be-selected", n);
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNLayersMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-layer-must-have-selected-items") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-layers-must-have-selected-items", n);
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getLayersWithSelectedItems().size() ? msg : null;
            }
        };
    }

    public EnableCheck createExactlyNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-one-feature-must-have-selected-items") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Exactly-n-features-must-have-selected-items", n);
                return n != ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createSelectedLayersMustBeEditableCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                for (Layer layer : EnableCheckFactory.this.workbenchContext.getLayerableNamePanel().getSelectedLayers()) {
                    if (layer.isEditable()) continue;
                    return I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Selected-layers-must-be-editable", layer.getName());
                }
                return null;
            }
        };
    }

    public EnableCheck createSelectedLayersMustNotBeEmpty() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                for (Layer layer : EnableCheckFactory.this.workbenchContext.getLayerableNamePanel().getSelectedLayers()) {
                    if (!layer.getFeatureCollectionWrapper().isEmpty()) continue;
                    return I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Selected-layers-must-not-be-empty", layer.getName());
                }
                return null;
            }
        };
    }

    public EnableCheck createFenceMustBeDrawnCheck() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                LayerViewPanel layerViewPanel = EnableCheckFactory.this.workbenchContext.getLayerViewPanel();
                return layerViewPanel == null || null == layerViewPanel.getFence() ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.A-fence-must-be-drawn") : null;
            }
        };
    }

    public EnableCheck createBetweenNAndMVectorsMustBeDrawnCheck(final int min, final int max) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return EnableCheckFactory.this.vectorCount() > max || EnableCheckFactory.this.vectorCount() < min ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.Between-and-vectors-must-be-drawn", min, max) : null;
            }
        };
    }

    int vectorCount() {
        return new WarpingVectorLayerFinder(this.workbenchContext).getVectors().size();
    }

    public EnableCheck createAtLeastNFeaturesMustHaveSelectedItemsCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-feature-must-have-selected-items") : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-features-must-have-selected-items", n);
                return n > ((SelectionManagerProxy)((Object)EnableCheckFactory.this.workbenchContext.getWorkbench().getFrame().getActiveInternalFrame())).getSelectionManager().getFeaturesWithSelectedItemsCount() ? msg : null;
            }
        };
    }

    public EnableCheck createSelectedLayerablesMustBeEither(final Class[] classes, final Class[] excluded) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                StringBuilder types = new StringBuilder("[");
                for (Class clz : classes) {
                    String clzName = I18N.getInstance().get(clz.getCanonicalName());
                    types.append(types.length() > 1 ? ", " + clzName : clzName);
                }
                types.append("]");
                StringBuilder exclusion = new StringBuilder("[");
                for (Class clz : excluded) {
                    String clzName = I18N.getInstance().get(clz.getCanonicalName());
                    exclusion.append(exclusion.length() > 1 ? ", " + clzName : clzName);
                }
                exclusion.append("]");
                String msg = I18N.getInstance().get("plugin.EnableCheckFactory.selected-layers-must-be-of-type", types, exclusion);
                LayerNamePanel lnp = EnableCheckFactory.this.workbenchContext.getLayerNamePanel();
                Layerable[] layerables = lnp instanceof LayerableNamePanel ? ((LayerableNamePanel)lnp).getSelectedLayerables().toArray(new Layerable[0]) : lnp.getSelectedLayers();
                for (Layer layer : layerables) {
                    boolean ok = false;
                    for (Class clz : classes) {
                        if (clz.isAssignableFrom(layer.getClass())) {
                            ok = true;
                            for (Class exc : excluded) {
                                if (!exc.isAssignableFrom(layer.getClass())) continue;
                                ok = false;
                                break;
                            }
                        }
                        if (ok) break;
                    }
                    if (ok) continue;
                    return msg;
                }
                return null;
            }
        };
    }

    public EnableCheck createSelectedLayerablesMustBeEither(Class[] classes) {
        return this.createSelectedLayerablesMustBeEither(new Class[]{Layer.class}, new Class[0]);
    }

    public EnableCheck createSelectedLayerablesMustBeVectorLayers() {
        return this.createSelectedLayerablesMustBeEither(new Class[]{Layer.class}, new Class[]{ReferencedImagesLayer.class});
    }

    public EnableCheck createSelectedLayerablesMustBeWMSLayers() {
        return this.createSelectedLayerablesMustBeEither(new Class[]{WMSLayer.class});
    }

    public EnableCheck createSelectedLayerablesMustBeRasterImageLayers() {
        return this.createSelectedLayerablesMustBeEither(new Class[]{RasterImageLayer.class});
    }

    public EnableCheck createSelectedLayerablesMustBeReferencedImagesLayers() {
        return this.createSelectedLayerablesMustBeEither(new Class[]{ReferencedImagesLayer.class});
    }

    public EnableCheck createRasterImageLayerExactlyNBandsMustExistCheck(final int n) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(EnableCheckFactory.this.workbenchContext.getWorkbench().getContext(), RasterImageLayer.class);
                int numbands = rLayer.getNumBands();
                String msg = n == 1 ? I18N.getInstance().get("plugin.EnableCheckFactory.exactly-1-band-must-exist-on-selected-raster-layer") : I18N.getInstance().get("plugin.EnableCheckFactory.exactly-{0}-bands-must-exist-on-selected-raster-layer", n);
                return n != numbands ? msg : null;
            }
        };
    }

    public EnableCheck createAtLeastNLayerablesOfTypeMustExistCheck(final int n, final Class<? extends Layerable> type) {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                if (EnableCheckFactory.this.workbenchContext.getLayerManager().getLayerables(type).size() >= n) {
                    return null;
                }
                String msg = n == 1 ? I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-one-layerables-must-exist") + ": " + type.getSimpleName() : I18N.getInstance().get("com.vividsolutions.jump.workbench.plugin.At-least-n-layerables-must-exist", n) + ": " + type.getSimpleName();
                return msg;
            }
        };
    }
}

