/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.locationtech.jts.geom.Envelope;

public class ObservableFeatureCollection
extends FeatureCollectionWrapper {
    private ArrayList<Listener> listeners = new ArrayList();

    public ObservableFeatureCollection(FeatureCollection fc) {
        super(fc);
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void add(Feature feature) {
        super.add(feature);
        this.fireFeaturesAdded(Collections.singletonList(feature));
    }

    @Override
    public void remove(Feature feature) {
        super.remove(feature);
        this.fireFeaturesRemoved(Collections.singletonList(feature));
    }

    private void fireFeaturesAdded(Collection<Feature> features) {
        for (Listener listener : this.listeners) {
            listener.featuresAdded(features);
        }
    }

    private void fireFeaturesRemoved(Collection<Feature> features) {
        for (Listener listener : this.listeners) {
            listener.featuresRemoved(features);
        }
    }

    @Override
    public void addAll(Collection<Feature> features) {
        super.addAll(features);
        this.fireFeaturesAdded(features);
    }

    @Override
    public void removeAll(Collection<Feature> features) {
        super.removeAll(features);
        this.fireFeaturesRemoved(features);
    }

    @Override
    public Collection<Feature> remove(Envelope env) {
        Collection<Feature> features = super.remove(env);
        this.fireFeaturesRemoved(features);
        return features;
    }

    public static interface Listener {
        public void featuresAdded(Collection<Feature> var1);

        public void featuresRemoved(Collection<Feature> var1);
    }
}

