/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.openjpeg;

import com.vividsolutions.jump.workbench.Logger;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.Metadata;
import org.openjump.core.rasterimage.Stats;
import org.openjump.util.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GMLJP2 {
    private final String location;
    private Metadata metadata = null;
    private static final Set<Integer> blockTerminators = new HashSet<Integer>(){
        {
            this.add(0);
            this.add(7);
        }
    };
    private static final NamespaceContext NSCONTEXT = new NamespaceContext(){

        @Override
        public String getNamespaceURI(String prefix) {
            return "http://www.opengis.net/gml";
        }

        @Override
        public String getPrefix(String namespace) {
            return "gml";
        }

        @Override
        public Iterator<String> getPrefixes(String namespace) {
            return new Iterator<String>(){
                boolean done = false;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public String next() {
                    this.done = true;
                    return "gml";
                }

                @Override
                public void remove() {
                }
            };
        }
    };

    GMLJP2(String location) {
        this.location = location;
        this.init();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private void init() {
        try {
            URI uri = new URI(this.location);
            this.metadata = this.readGmlMetadata(Paths.get(uri));
        }
        catch (URISyntaxException e) {
            Logger.warn(e);
        }
    }

    private Metadata readGmlMetadata(Path jp2Path) {
        Metadata metadata = null;
        ByteSequenceMatcher jp2cMatcher = new ByteSequenceMatcher(new int[]{99, 50, 112, 106});
        ByteSequenceMatcher xmlTagMatcher = new ByteSequenceMatcher(new int[]{32, 108, 109, 120});
        if (jp2Path != null && Files.isReadable(jp2Path)) {
            try (FileInputStream is = new FileInputStream(String.valueOf(jp2Path));){
                int currentByte;
                while ((currentByte = ((InputStream)is).read()) != -1 && !jp2cMatcher.matches(currentByte)) {
                    String xmlString;
                    if (!xmlTagMatcher.matches(currentByte) || !(xmlString = this.extractBlock(is)).contains("gml:FeatureCollection")) continue;
                    DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                    try {
                        System.out.println(xmlString);
                        docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        docBuilderFactory.setNamespaceAware(true);
                        DocumentBuilder builder = docBuilderFactory.newDocumentBuilder();
                        Document doc = builder.parse(new InputSource(new StringReader(xmlString.trim())));
                        metadata = this.toMetadata(doc);
                    }
                    catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException ex1) {
                        Logger.error(ex1);
                    }
                    if (!xmlString.contains("gml:FeatureCollection")) continue;
                    break;
                }
            }
            catch (IOException ex2) {
                Logger.error(ex2);
            }
        }
        return metadata;
    }

    private Metadata toMetadata(Document xmlDoc) throws XPathExpressionException {
        Element root = xmlDoc.getDocumentElement();
        Element envNode = XPathUtils.getElement("//gml:boundedBy/gml:Envelope", root, NSCONTEXT);
        Element lowerCorner = XPathUtils.getElement("//gml:lowerCorner", root, NSCONTEXT);
        Element upperCorner = XPathUtils.getElement("//gml:upperCorner", root, NSCONTEXT);
        Element grid = XPathUtils.getElement("//gml:limits/gml:GridEnvelope/gml:high", root, NSCONTEXT);
        String srsAttribute = envNode.getAttribute("srsName");
        String srsName = srsAttribute.contains("EPSG:") ? "EPSG:" + envNode.getAttribute("srsName").split("EPSG:")[1] : srsAttribute;
        String[] lower = lowerCorner.getTextContent().split(" ");
        String[] upper = upperCorner.getTextContent().split(" ");
        String[] gridSize = grid.getTextContent().split(" ");
        double llx = Double.parseDouble(lower[0]);
        double lly = Double.parseDouble(lower[1]);
        double urx = Double.parseDouble(upper[0]);
        double ury = Double.parseDouble(upper[1]);
        int nbcol = Integer.parseInt(gridSize[0]) + 1;
        int nbrow = Integer.parseInt(gridSize[1]) + 1;
        if (Math.abs(llx) + Math.abs(lly) + Math.abs(urx) + Math.abs(ury) < 540.0) {
            llx = Double.parseDouble(lower[1]);
            lly = Double.parseDouble(lower[0]);
            urx = Double.parseDouble(upper[1]);
            ury = Double.parseDouble(upper[0]);
        }
        return new Metadata(new Envelope(llx, urx, lly, ury), new Envelope(llx, urx, lly, ury), new Point(nbcol, nbrow), new Point(nbcol, nbrow), (urx - llx) / (double)nbcol, (ury - lly) / (double)nbrow, Double.NaN, new Stats(3));
    }

    private String extractBlock(InputStream is) throws IOException {
        int current;
        StringBuilder builder = new StringBuilder();
        while (!blockTerminators.contains(current = is.read())) {
            builder.append((char)current);
        }
        return builder.toString();
    }

    private static class ByteSequenceMatcher {
        private final int[] queue;
        private final int[] sequence;

        ByteSequenceMatcher(int[] sequenceToMatch) {
            this.sequence = sequenceToMatch;
            this.queue = new int[sequenceToMatch.length];
        }

        public boolean matches(int unsignedByte) {
            this.insert(unsignedByte);
            return this.isMatch();
        }

        private void insert(int unsignedByte) {
            System.arraycopy(this.queue, 0, this.queue, 1, this.sequence.length - 1);
            this.queue[0] = unsignedByte;
        }

        private boolean isMatch() {
            boolean result = true;
            for (int i = 0; i < this.sequence.length; ++i) {
                boolean bl = result = this.queue[i] == this.sequence[i];
                if (!result) break;
            }
            return result;
        }
    }
}

