/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery.mrsid;

import com.vividsolutions.jump.JUMPException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class SIDInfo {
    private String fileName;
    private int pixelWidth;
    private int pixelHeight;
    private double xres;
    private double xrot;
    private double yrot;
    private double yres;
    private double upper_left_x;
    private double upper_left_y;
    private int numLevels;
    private String colorSpace;

    SIDInfo(String fileName, int pixelWidth, int pixelHeight, double xres, double xrot, double yrot, double yres, double ulx, double uly, int numLevels, String colorSpace) {
        this.fileName = fileName;
        this.pixelWidth = pixelWidth;
        this.pixelHeight = pixelHeight;
        this.xres = xres;
        this.xrot = xrot;
        this.yrot = yrot;
        this.yres = yres;
        this.upper_left_x = ulx;
        this.upper_left_y = uly;
        this.numLevels = numLevels;
        this.colorSpace = colorSpace;
    }

    String getFileName() {
        return this.fileName;
    }

    int getPixelWidth() {
        return this.pixelWidth;
    }

    int getPixelHeight() {
        return this.pixelHeight;
    }

    double getXRes() {
        return this.xres;
    }

    double getXRot() {
        return this.xrot;
    }

    double getYRot() {
        return this.yrot;
    }

    double getYRes() {
        return this.yres;
    }

    double getUpperLeftX() {
        return this.upper_left_x;
    }

    double getUpperLeftY() {
        return this.upper_left_y;
    }

    int getNumLevels() {
        return this.numLevels;
    }

    String getColorSpace() {
        return this.colorSpace;
    }

    static SIDInfo readInfo(String sidFilename) throws JUMPException {
        int sidPixelWidth = 0;
        int sidPixelHeight = 0;
        double sid_xres = 1.0;
        double sid_xrot = 0.0;
        double sid_yrot = 0.0;
        double sid_yres = 1.0;
        double sid_ulx = 0.0;
        double sid_uly = 0.0;
        int maxLevel = 0;
        int numInfoItems = 0;
        String colorSpace = null;
        try {
            File file = File.createTempFile("mrsidinfo-", ".txt");
            String[] runStr = new String[]{"mrsidgeoinfo", sidFilename, "-quiet", "-log", file.getCanonicalPath()};
            Process p = Runtime.getRuntime().exec(runStr);
            p.waitFor();
            p.destroy();
            FileReader fin = new FileReader(file);
            BufferedReader in = new BufferedReader(fin);
            String lineIn = in.readLine();
            while (in.ready()) {
                String value = "";
                if (lineIn.indexOf("width:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sidPixelWidth = Integer.parseInt(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("height:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sidPixelHeight = Integer.parseInt(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("number of levels:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    maxLevel = Integer.parseInt(value.trim());
                    ++numInfoItems;
                }
                if (lineIn.indexOf("X UL:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_ulx = Double.parseDouble(value.trim().replace(',', '.'));
                    ++numInfoItems;
                }
                if (lineIn.indexOf("Y UL:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_uly = Double.parseDouble(value.trim().replace(',', '.'));
                    ++numInfoItems;
                }
                if (lineIn.indexOf("X res:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_xres = Double.parseDouble(value.trim().replace(',', '.'));
                    ++numInfoItems;
                }
                if (lineIn.indexOf("Y res:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    sid_yres = Double.parseDouble(value.trim().replace(',', '.'));
                    ++numInfoItems;
                }
                if (lineIn.indexOf("color space:") != -1) {
                    value = lineIn.substring(lineIn.indexOf(":") + 1);
                    colorSpace = value.trim();
                    ++numInfoItems;
                }
                lineIn = in.readLine();
            }
            in.close();
            fin.close();
            file.delete();
            if (numInfoItems == 8) {
                return new SIDInfo(sidFilename, sidPixelWidth, sidPixelHeight, sid_xres, sid_xrot, sid_yrot, sid_yres, sid_ulx, sid_uly, maxLevel, colorSpace);
            }
            return null;
        }
        catch (Throwable t) {
            throw new JUMPException(t);
        }
    }
}

