/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.imagery;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.StringUtil;
import com.vividsolutions.jump.workbench.imagery.ReferencedImage;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoImageFactory;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

public class ImageryLayerDataset {
    private static String prefix = "IMG";
    public static final String ATTR_GEOMETRY = prefix + "_GEOM";
    public static final String ATTR_URI = prefix + "_URI";
    public static final String ATTR_FACTORY = prefix + "_FACT";
    public static final String ATTR_ERROR = prefix + "ERROR";
    public static final String ATTR_TYPE = prefix + "_TYPE";
    public static final String ATTR_LOADER = prefix + "LOADR";
    public static final String OLD_ATTR_GEOMETRY = "GEOMETRY";
    public static final String OLD_ATTR_FILE = "IMAGEFILE";
    public static final String OLD_ATTR_FORMAT = "IMAGEFORMAT";
    public static final String OLD_ATTR_ERROR = "IMAGEERROR";
    public static final String OLD_ATTR_TYPE = "IMAGETYPE";
    public static final String OLD_ATTR_FACTORY = "IMAGEFACT";
    private Map<Feature, ReferencedImage> featureToReferencedImageMap = new WeakHashMap<Feature, ReferencedImage>();
    public static FeatureSchema SCHEMA = new FeatureSchema(){
        {
            this.addAttribute(ATTR_GEOMETRY, AttributeType.GEOMETRY);
            this.addAttribute(ATTR_URI, AttributeType.STRING);
            this.addAttribute(ATTR_FACTORY, AttributeType.STRING);
            this.addAttribute(ATTR_ERROR, AttributeType.STRING);
            this.addAttribute(ATTR_TYPE, AttributeType.STRING);
            this.addAttribute(ATTR_LOADER, AttributeType.STRING);
        }
    };

    public static FeatureSchema getSchema() {
        return SCHEMA;
    }

    private void removeImage(Feature feature) {
        this.featureToReferencedImageMap.remove(feature);
    }

    private void addImage(Feature feature, ReferencedImage referencedImage) {
        this.featureToReferencedImageMap.put(feature, referencedImage);
    }

    public ReferencedImage referencedImage(Feature feature) throws Exception {
        if (feature.getString(ATTR_ERROR) != null && !feature.getString(ATTR_ERROR).equals("")) {
            return null;
        }
        if (!this.featureToReferencedImageMap.containsKey(feature)) {
            this.attachImage(feature);
        }
        return this.featureToReferencedImageMap.get(feature);
    }

    public void attachImage(Feature feature) throws Exception {
        ImageryLayerDataset.attachImage(feature, this);
    }

    public static void attachImage(Feature feature, ImageryLayerDataset ils) throws Exception {
        String imageFilePath = feature.getString(ATTR_URI);
        if (imageFilePath == null) {
            throw new Exception("Image file path in '" + ATTR_URI + "' attribute is null");
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        ReferencedImageFactory imageFactory = ImageryLayerDataset.createFeatureFactory(feature);
        ReferencedImage referencedImage = imageFactory.createImage(imageFilePath);
        ils.addImage(feature, referencedImage);
        if (!(feature.getGeometry() instanceof Polygon) || feature.getGeometry().getNumPoints() != 5) {
            Envelope env = referencedImage.getEnvelope();
            Geometry boundingBox = geometryFactory.toGeometry(env);
            feature.setGeometry(boundingBox);
        }
        feature.setAttribute(ATTR_TYPE, (Object)referencedImage.getType());
    }

    public void dispose() {
        if (this.featureToReferencedImageMap != null) {
            this.featureToReferencedImageMap.clear();
            this.featureToReferencedImageMap = null;
        }
    }

    public static Feature saveFeatureError(Feature feature, Throwable t) {
        feature.setAttribute(ATTR_ERROR, (Object)(WorkbenchFrame.toMessage(t) + "\n\n" + StringUtil.stackTrace(t)));
        return feature;
    }

    public static Feature saveFeatureImgAttribs(Feature feature, ReferencedImageFactory imageFactory) {
        Object loader;
        feature.setAttribute(ATTR_FACTORY, (Object)imageFactory.getClass().getName());
        if (imageFactory instanceof GeoImageFactory && (loader = ((GeoImageFactory)imageFactory).getLoader()) != null) {
            feature.setAttribute(ATTR_LOADER, (Object)loader.getClass().getName());
        }
        return feature;
    }

    public static Feature saveFeatureImgAttribs(Feature feature, Feature imprint) {
        if (ImageryLayerDataset.isOldImageFeature(imprint)) {
            feature.setAttribute(ATTR_FACTORY, (Object)imprint.getString(OLD_ATTR_FACTORY));
            String imageFile = imprint.getString(OLD_ATTR_FILE);
            if (imageFile != null) {
                feature.setAttribute(ATTR_URI, (Object)new File(imageFile).toURI().toString());
            }
        } else if (ImageryLayerDataset.isNewImageFeature(imprint)) {
            feature.setAttribute(ATTR_FACTORY, (Object)imprint.getString(ATTR_FACTORY));
            feature.setAttribute(ATTR_LOADER, (Object)imprint.getString(ATTR_LOADER));
            feature.setAttribute(ATTR_URI, (Object)imprint.getString(ATTR_URI));
        }
        return feature;
    }

    public static ReferencedImageFactory createFeatureFactory(Feature feature) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String factoryClassPath = feature.getString(ATTR_FACTORY);
        if (factoryClassPath == null) {
            throw new InstantiationException("Cannot instantiate ReferencedImageFactory: " + ATTR_FACTORY + " is null");
        }
        String loaderClassPath = feature.getString(ATTR_LOADER);
        if (factoryClassPath == null) {
            throw new InstantiationException("Cannot instantiate ReferencedImageFactory: " + ATTR_LOADER + " is null");
        }
        Class<?> imageFactoryClass = Class.forName(factoryClassPath);
        ReferencedImageFactory imageFactory = (ReferencedImageFactory)imageFactoryClass.newInstance();
        if (!loaderClassPath.isEmpty() && imageFactory instanceof GeoImageFactory) {
            try {
                String loaderParam = "";
                if (loaderClassPath.contains("|")) {
                    String[] parts = loaderClassPath.split("\\|", 1);
                    loaderClassPath = parts[0];
                    loaderParam = parts[1];
                }
                Class<?> loaderClass = Class.forName(loaderClassPath);
                Object loader = null;
                loader = loaderClass.newInstance();
                ((GeoImageFactory)imageFactory).setLoader(loader);
            }
            catch (ClassNotFoundException e) {
                System.out.println("ILDS: TODO - show user warning - " + e);
            }
        }
        return imageFactory;
    }

    public static boolean isImageFeature(Feature f) {
        return ImageryLayerDataset.isNewImageFeature(f) || ImageryLayerDataset.isOldImageFeature(f);
    }

    public static boolean isNewImageFeature(Feature f) {
        String[] attribs;
        for (String key : attribs = new String[]{ATTR_URI, ATTR_FACTORY, ATTR_ERROR, ATTR_TYPE, ATTR_LOADER}) {
            if (f.getSchema().hasAttribute(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOldImageFeature(Feature f) {
        String[] attribs;
        for (String key : attribs = new String[]{OLD_ATTR_FILE, OLD_ATTR_FORMAT, OLD_ATTR_ERROR, OLD_ATTR_TYPE, OLD_ATTR_FACTORY}) {
            if (f.getSchema().hasAttribute(key)) continue;
            return false;
        }
        return true;
    }
}

