/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.workbench.Setup;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactory;
import com.vividsolutions.jump.workbench.imagery.ReferencedImageFactoryFileLayerLoader;
import com.vividsolutions.jump.workbench.imagery.ecw.ECWImageFactory;
import com.vividsolutions.jump.workbench.imagery.ecw.JPEG2000ImageFactory;
import com.vividsolutions.jump.workbench.imagery.geoimg.GeoImageFactoryFileLayerLoader;
import com.vividsolutions.jump.workbench.imagery.geotiff.GeoTIFFImageFactory;
import com.vividsolutions.jump.workbench.imagery.graphic.CommonsImageFactory;
import com.vividsolutions.jump.workbench.imagery.mrsid.MrSIDImageFactory;
import com.vividsolutions.jump.workbench.imagery.openjpeg.OpenJpegImageFactory;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OptionsDialog;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DrawPolygonFenceTool;
import com.vividsolutions.jump.workbench.ui.cursortool.DrawRectangleFenceTool;
import com.vividsolutions.jump.workbench.ui.cursortool.FeatureInfoTool;
import com.vividsolutions.jump.workbench.ui.cursortool.OrCompositeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.SelectFeaturesTool;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.EditingPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ClearSelectionPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.NewTaskPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.OutputWindowPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.RedoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.UndoPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.ViewAttributesPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.LayerRendererFactory;
import com.vividsolutions.jump.workbench.ui.renderer.RenderingManager;
import com.vividsolutions.jump.workbench.ui.renderer.WmsLayerRendererFactory;
import com.vividsolutions.jump.workbench.ui.renderer.style.ArrowLineStringEndpointStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ArrowLineStringSegmentStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.CircleLineStringEndpointStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.MetricsLineStringSegmentStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexIndexLineSegmentStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexXYLineSegmentStyle;
import com.vividsolutions.jump.workbench.ui.snap.SnapToVerticesPolicy;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import com.vividsolutions.jump.workbench.ui.zoom.PanTool;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomNextPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomPreviousPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToFencePlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToFullExtentPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomTool;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.swing.JToggleButton;
import org.locationtech.jts.util.Assert;
import org.openjump.core.feature.BeanshellAttributeOperationFactory;
import org.openjump.core.rasterimage.AddRasterImageLayerWizard;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterImageLayerRendererFactory;
import org.openjump.core.ui.DatasetOptionsPanel;
import org.openjump.core.ui.io.file.DataSourceFileLayerLoader;
import org.openjump.core.ui.io.file.FileLayerLoader;
import org.openjump.core.ui.plugin.datastore.AddDataStoreLayerWizard;
import org.openjump.core.ui.plugin.datastore.AddWritableDataStoreLayerWizard;
import org.openjump.core.ui.plugin.file.DataSourceQueryChooserOpenWizard;
import org.openjump.core.ui.plugin.file.OpenWizardPlugIn;
import org.openjump.core.ui.plugin.layer.LayerableStylePlugIn;
import org.openjump.core.ui.plugin.layer.pirolraster.RasterImageContextMenu;
import org.openjump.core.ui.plugin.tools.AdvancedMeasureOptionsPanel;
import org.openjump.core.ui.plugin.tools.AdvancedMeasureTool;
import org.openjump.core.ui.plugin.tools.ZoomRealtimeTool;
import org.openjump.core.ui.plugin.view.SuperZoomPanTool;
import org.openjump.core.ui.plugin.wms.AddWmsLayerWizard;
import org.openjump.core.ui.style.decoration.ArrowLineStringMiddlepointStyle;
import org.openjump.core.ui.style.decoration.SegmentDownhillArrowStyle;
import org.openjump.core.ui.style.decoration.VertexZValueStyle;
import org.openjump.core.ui.swing.factory.field.ComboBoxFieldComponentFactory;
import org.openjump.core.ui.swing.factory.field.FieldComponentFactoryRegistry;
import org.openjump.core.ui.swing.factory.field.FileFieldComponentFactory;

public class JUMPConfiguration
implements Setup {
    private final ClearSelectionPlugIn clearSelectionPlugIn = new ClearSelectionPlugIn();
    private final EditingPlugIn editingPlugIn = EditingPlugIn.getInstance();
    private final NewTaskPlugIn newTaskPlugIn = new NewTaskPlugIn();
    private final LayerableStylePlugIn changeStylesPlugIn = new LayerableStylePlugIn();
    private final UndoPlugIn undoPlugIn = new UndoPlugIn();
    private final RedoPlugIn redoPlugIn = new RedoPlugIn();
    private final ViewAttributesPlugIn viewAttributesPlugIn = new ViewAttributesPlugIn();
    private final OutputWindowPlugIn outputWindowPlugIn = new OutputWindowPlugIn();
    private final ZoomNextPlugIn zoomNextPlugIn = new ZoomNextPlugIn();
    private final ZoomPreviousPlugIn zoomPreviousPlugIn = new ZoomPreviousPlugIn();
    private final ZoomToFencePlugIn zoomToFencePlugIn = new ZoomToFencePlugIn();
    private final ZoomToFullExtentPlugIn zoomToFullExtentPlugIn = new ZoomToFullExtentPlugIn();
    private final ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();

    @Override
    public void setup(WorkbenchContext workbenchContext) throws Exception {
        PlugInContext plugInContext = new PlugInContext(workbenchContext, null, null, null, null);
        this.configureStyles(workbenchContext);
        workbenchContext.getWorkbench().getBlackboard().put(SnapToVerticesPolicy.ENABLED_KEY, true);
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        FeatureInstaller featureInstaller = FeatureInstaller.getInstance(workbenchContext);
        this.configureToolBar(workbenchContext, checkFactory);
        this.configureMainMenus(workbenchContext, checkFactory, featureInstaller);
        this.initializeRenderingManager();
        this.initializeFieldComponentFactories(workbenchContext);
        this.initializeAttributeOperationFactories(plugInContext);
        this.initializeBuiltInPlugIns(plugInContext);
        PersistentBlackboardPlugIn.get(workbenchContext).put(EditTransaction.ROLLING_BACK_INVALID_EDITS_KEY, true);
    }

    private void initializeRenderingManager() {
        RenderingManager.setRendererFactory(Layer.class, new LayerRendererFactory());
        RenderingManager.setRendererFactory(WMSLayer.class, new WmsLayerRendererFactory());
    }

    private void configureMainMenus(WorkbenchContext workbenchContext, EnableCheckFactory checkFactory, FeatureInstaller featureInstaller) throws Exception {
        String[] fileMenuPath = new String[]{MenuNames.FILE};
        featureInstaller.addMenuSeparator(fileMenuPath);
        workbenchContext.getWorkbench().getFrame().new WorkbenchFrame.ExitPlugin().initialize(workbenchContext.createPlugInContext());
    }

    private void configureStyles(WorkbenchContext workbenchContext) {
        WorkbenchFrame frame = workbenchContext.getWorkbench().getFrame();
        frame.addChoosableStyleClass(VertexXYLineSegmentStyle.VertexXY.class);
        frame.addChoosableStyleClass(VertexIndexLineSegmentStyle.VertexIndex.class);
        frame.addChoosableStyleClass(MetricsLineStringSegmentStyle.LengthAngle.class);
        frame.addChoosableStyleClass(ArrowLineStringSegmentStyle.Open.class);
        frame.addChoosableStyleClass(ArrowLineStringSegmentStyle.Solid.class);
        frame.addChoosableStyleClass(ArrowLineStringSegmentStyle.NarrowSolid.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.FeathersStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.FeathersEnd.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.OpenStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.OpenEnd.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.SolidStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.SolidEnd.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.NarrowSolidStart.class);
        frame.addChoosableStyleClass(ArrowLineStringEndpointStyle.NarrowSolidEnd.class);
        frame.addChoosableStyleClass(CircleLineStringEndpointStyle.Start.class);
        frame.addChoosableStyleClass(CircleLineStringEndpointStyle.End.class);
        frame.addChoosableStyleClass(ArrowLineStringMiddlepointStyle.NarrowSolidMiddle.class);
        frame.addChoosableStyleClass(SegmentDownhillArrowStyle.NarrowSolidMiddle.class);
        frame.addChoosableStyleClass(SegmentDownhillArrowStyle.Open.class);
        frame.addChoosableStyleClass(SegmentDownhillArrowStyle.Solid.class);
        frame.addChoosableStyleClass(VertexZValueStyle.VertexZValue.class);
    }

    private QuasimodeTool add(CursorTool tool, WorkbenchContext context) {
        return context.getWorkbench().getFrame().getToolBar().addCursorTool(tool).getQuasimodeTool();
    }

    private void configureToolBar(WorkbenchContext workbenchContext, EnableCheckFactory checkFactory) {
        WorkbenchFrame frame = workbenchContext.getWorkbench().getFrame();
        frame.getToolBar().addPlugIn(this.newTaskPlugIn.getIcon(20), this.newTaskPlugIn, NewTaskPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        this.add(new ZoomTool(workbenchContext), workbenchContext);
        this.add(new PanTool(workbenchContext), workbenchContext);
        this.add(new SuperZoomPanTool(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        frame.getToolBar().addPlugIn(this.zoomToFullExtentPlugIn.getIcon(new Dimension(20, 20)), this.zoomToFullExtentPlugIn, this.zoomToFullExtentPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomToSelectedItemsPlugIn.getIcon(), this.zoomToSelectedItemsPlugIn, ZoomToSelectedItemsPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        this.add(new ZoomRealtimeTool(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomToFencePlugIn.getIcon(), this.zoomToFencePlugIn, new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createFenceMustBeDrawnCheck()), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomPreviousPlugIn.getIcon(), this.zoomPreviousPlugIn, this.zoomPreviousPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.zoomNextPlugIn.getIcon(), this.zoomNextPlugIn, this.zoomNextPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.changeStylesPlugIn.getIcon(), this.changeStylesPlugIn, this.changeStylesPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.viewAttributesPlugIn.getIcon(), this.viewAttributesPlugIn, this.viewAttributesPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        SelectFeaturesTool sft = new SelectFeaturesTool(workbenchContext);
        this.add(sft, workbenchContext);
        frame.getToolBar().getButton(sft.getClass()).doClick();
        frame.getToolBar().addPlugIn(this.clearSelectionPlugIn.getIcon(), this.clearSelectionPlugIn, this.clearSelectionPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        this.add(new OrCompositeTool(){

            @Override
            public String getName() {
                return I18N.getInstance().get("JUMPConfiguration.fence");
            }
        }.add(new DrawRectangleFenceTool(workbenchContext)).add(new DrawPolygonFenceTool(workbenchContext)), workbenchContext);
        this.add(new FeatureInfoTool(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        this.configureEditingButton(workbenchContext);
        frame.getToolBar().addSeparator();
        AdvancedMeasureTool advancedMeasureTool = new AdvancedMeasureTool(workbenchContext);
        workbenchContext.getWorkbench().getFrame().getToolBar().addCursorTool(advancedMeasureTool, advancedMeasureTool.getToolbarButton());
        OptionsDialog.instance(workbenchContext.getWorkbench()).addTab(I18N.getInstance().get("org.openjump.core.ui.plugin.tools.AdvancedMeasurePlugin.OptionPanelTitle"), new AdvancedMeasureOptionsPanel(workbenchContext));
        frame.getToolBar().addSeparator();
        frame.getToolBar().addPlugIn(this.undoPlugIn.getIcon(), this.undoPlugIn, this.undoPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addPlugIn(this.redoPlugIn.getIcon(), this.redoPlugIn, this.redoPlugIn.createEnableCheck(workbenchContext), workbenchContext);
        frame.getToolBar().addSeparator();
        workbenchContext.getWorkbench().getFrame().getOutputFrame().setButton(frame.getToolBar().addPlugIn(this.outputWindowPlugIn.getIcon(), this.outputWindowPlugIn, new MultiEnableCheck(), workbenchContext));
        frame.getToolBar().addSeparator();
    }

    private void configureEditingButton(final WorkbenchContext workbenchContext) {
        final JToggleButton toggleButton = new JToggleButton();
        workbenchContext.getWorkbench().getFrame().getToolBar().add(toggleButton, this.editingPlugIn.getName(), EditingPlugIn.ICON, AbstractPlugIn.toActionListener(this.editingPlugIn, workbenchContext, new TaskMonitorManager()), null);
        workbenchContext.getWorkbench().getFrame().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                JUMPConfiguration.this.editingPlugIn.getToolbox(workbenchContext).addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        toggleButton.setSelected(true);
                    }

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        toggleButton.setSelected(false);
                    }
                });
            }
        });
    }

    private void initializeFieldComponentFactories(WorkbenchContext workbenchContext) {
        FieldComponentFactoryRegistry.setFactory(workbenchContext, "FileString", new FileFieldComponentFactory(workbenchContext));
        FieldComponentFactoryRegistry.setFactory(workbenchContext, "CharSetComboBoxField", new ComboBoxFieldComponentFactory(workbenchContext, null, Charset.availableCharsets().keySet().toArray()));
    }

    private void initializeAttributeOperationFactories(PlugInContext context) {
        new BeanshellAttributeOperationFactory(context);
    }

    private void initializeBuiltInPlugIns(PlugInContext context) throws Exception {
        Field[] fields = this.getClass().getDeclaredFields();
        Object field = null;
        for (int i = 0; i < fields.length; ++i) {
            try {
                field = fields[i].get(this);
            }
            catch (IllegalAccessException e) {
                Assert.shouldNeverReachHere();
            }
            if (!(field instanceof PlugIn)) continue;
            PlugIn plugIn = (PlugIn)field;
            plugIn.initialize(context);
            context.getFeatureInstaller().registerShortcuts(plugIn);
        }
    }

    public void postExtensionInitialization(WorkbenchContext workbenchContext) {
        AddDataStoreLayerWizard addDataStoreLayerWizard = new AddDataStoreLayerWizard(workbenchContext);
        OpenWizardPlugIn.addWizard(workbenchContext, addDataStoreLayerWizard);
        AddWmsLayerWizard addWmsLayerWizard = new AddWmsLayerWizard(workbenchContext);
        OpenWizardPlugIn.addWizard(workbenchContext, addWmsLayerWizard);
        AddRasterImageLayerWizard addRasterImageLayerWizard = new AddRasterImageLayerWizard(workbenchContext);
        OpenWizardPlugIn.addWizard(workbenchContext, addRasterImageLayerWizard);
        AddWritableDataStoreLayerWizard addWritableDataStoreLayerWizard = new AddWritableDataStoreLayerWizard(workbenchContext, "org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager");
        OpenWizardPlugIn.addWizard(workbenchContext, addWritableDataStoreLayerWizard);
        RenderingManager.setRendererFactory(RasterImageLayer.class, new RasterImageLayerRendererFactory());
        workbenchContext.getWorkbench().getFrame().getNodeClassToPopupMenuMap().put(RasterImageLayer.class, RasterImageContextMenu.getInstance(workbenchContext.createPlugInContext()));
        Registry registry = workbenchContext.getRegistry();
        List<DataSourceQueryChooser> loadChoosers = DataSourceQueryChooserManager.get(workbenchContext.getBlackboard()).getLoadDataSourceQueryChoosers();
        for (DataSourceQueryChooser chooser : loadChoosers) {
            Object showCharsetSelection;
            if (!(chooser instanceof FileDataSourceQueryChooser)) continue;
            FileDataSourceQueryChooser fileChooser = (FileDataSourceQueryChooser)chooser;
            Class dataSourceClass = fileChooser.getDataSourceClass();
            String description = fileChooser.getDescription();
            List<String> extensions = Arrays.asList(fileChooser.getExtensions());
            DataSourceFileLayerLoader fileLoader = new DataSourceFileLayerLoader(workbenchContext, dataSourceClass, description, extensions);
            if (description.equals("GML 2.0")) {
                fileLoader.addOption("Input Template File", "FileString", true);
            }
            if (dataSourceClass == StandardReaderWriterFileDataSource.Shapefile.class && (showCharsetSelection = PersistentBlackboardPlugIn.get(workbenchContext).get(DatasetOptionsPanel.BB_DATASET_OPTIONS_SHOW_CHARSET_SELECTION)) instanceof Boolean && ((Boolean)showCharsetSelection).booleanValue()) {
                fileLoader.addOption("charset", "CharSetComboBoxField", Charset.defaultCharset().displayName(), true);
            }
            registry.createEntry(FileLayerLoader.KEY, fileLoader);
        }
        this.addImageFactory(workbenchContext, registry, new OpenJpegImageFactory(), null);
        this.addImageFactory(workbenchContext, registry, new CommonsImageFactory(), null);
        this.addImageFactory(workbenchContext, registry, new ECWImageFactory(), null);
        this.addImageFactory(workbenchContext, registry, new JPEG2000ImageFactory(), null);
        this.addImageFactory(workbenchContext, registry, new GeoTIFFImageFactory(), null);
        this.addImageFactory(workbenchContext, registry, new MrSIDImageFactory(), null);
        try {
            GeoImageFactoryFileLayerLoader.register(workbenchContext);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        DataSourceQueryChooserManager manager = DataSourceQueryChooserManager.get(workbenchContext.getWorkbench().getBlackboard());
        for (DataSourceQueryChooser chooser : manager.getLoadDataSourceQueryChoosers()) {
            if (chooser instanceof FileDataSourceQueryChooser) continue;
            DataSourceQueryChooserOpenWizard wizard = new DataSourceQueryChooserOpenWizard(workbenchContext, chooser);
            OpenWizardPlugIn.addWizard(workbenchContext, wizard);
        }
    }

    private void addImageFactory(WorkbenchContext workbenchContext, Registry registry, ReferencedImageFactory factory, String[] supportFileExtensions) {
        if (factory.isAvailable(workbenchContext)) {
            ReferencedImageFactoryFileLayerLoader loader = new ReferencedImageFactoryFileLayerLoader(workbenchContext, factory, supportFileExtensions);
            registry.createEntry(FileLayerLoader.KEY, loader);
            registry.createEntry(ReferencedImageFactory.REGISTRY_CLASSIFICATION, factory);
        }
    }
}

