/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.warp;

import Jama.Matrix;
import com.vividsolutions.jump.warp.CoordinateTransform;
import org.locationtech.jts.geom.Coordinate;

public class ProjectiveTransform
extends CoordinateTransform {
    private Matrix a;

    public ProjectiveTransform(Coordinate p1, Coordinate p1_, Coordinate p2, Coordinate p2_, Coordinate p3, Coordinate p3_, Coordinate p4, Coordinate p4_) {
        this.initialize(p1, p1_, p2, p2_, p3, p3_, p4, p4_);
    }

    private void initialize(Coordinate p1, Coordinate p1_, Coordinate p2, Coordinate p2_, Coordinate p3, Coordinate p3_, Coordinate p4, Coordinate p4_) {
        double[][] Xarray = new double[][]{{p1.x, p1.y, 1.0, 0.0, 0.0, 0.0, -p1_.x * p1.x, -p1_.x * p1.y}, {0.0, 0.0, 0.0, p1.x, p1.y, 1.0, -p1_.y * p1.x, -p1_.y * p1.y}, {p2.x, p2.y, 1.0, 0.0, 0.0, 0.0, -p2_.x * p2.x, -p2_.x * p2.y}, {0.0, 0.0, 0.0, p2.x, p2.y, 1.0, -p2_.y * p2.x, -p2_.y * p2.y}, {p3.x, p3.y, 1.0, 0.0, 0.0, 0.0, -p3_.x * p3.x, -p3_.x * p3.y}, {0.0, 0.0, 0.0, p3.x, p3.y, 1.0, -p3_.y * p3.x, -p3_.y * p3.y}, {p4.x, p4.y, 1.0, 0.0, 0.0, 0.0, -p4_.x * p4.x, -p4_.x * p4.y}, {0.0, 0.0, 0.0, p4.x, p4.y, 1.0, -p4_.y * p4.x, -p4_.y * p4.y}};
        Matrix X = new Matrix((double[][])Xarray);
        double[][] x_array = new double[][]{{p1_.x}, {p1_.y}, {p2_.x}, {p2_.y}, {p3_.x}, {p3_.y}, {p4_.x}, {p4_.y}};
        Matrix x_ = new Matrix((double[][])x_array);
        this.a = X.solve(x_);
    }

    @Override
    public Coordinate transform(Coordinate c) {
        double wx_ = this.a.get(0, 0) * c.x + this.a.get(1, 0) * c.y + this.a.get(2, 0);
        double wy_ = this.a.get(3, 0) * c.x + this.a.get(4, 0) * c.y + this.a.get(5, 0);
        double w = this.a.get(6, 0) * c.x + this.a.get(7, 0) * c.y + 1.0;
        double x_ = wx_ / w;
        double y_ = wy_ / w;
        return new Coordinate(x_, y_);
    }
}

