/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util.commandline;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.commandline.Param;
import com.vividsolutions.jump.util.commandline.ParseException;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;

public class ParamSpec {
    private static final int NARGS_ZERO_OR_MORE = -1;
    private static final int NARGS_ONE_OR_MORE = -2;
    private static final int NARGS_ZERO_OR_ONE = -3;
    private final Vector<String> names = new Vector();
    private final int nNeededArgs;
    private String syntaxPattern;
    private String doc;
    private final Vector<Param> params = new Vector();

    public ParamSpec(String[] optNames, int numberOfNeededArgs, String desc) {
        for (String name : optNames) {
            this.names.add(name.toLowerCase());
        }
        this.doc = desc;
        this.nNeededArgs = numberOfNeededArgs;
    }

    public ParamSpec(String optName, int needed, String desc) {
        this(new String[]{optName}, needed, desc);
    }

    public void setDoc(String docLine) {
        this.doc = docLine;
    }

    public String getDesc() {
        return this.doc;
    }

    public int getNumOptions() {
        return this.params.size();
    }

    public Param getOption(int i) {
        if (this.params.size() > 0) {
            return this.params.elementAt(i);
        }
        return null;
    }

    public Param getParam() {
        if (this.params.size() > 0) {
            return this.params.lastElement();
        }
        return null;
    }

    public Iterator<String> getAllArguments() {
        Vector<String> all = new Vector<String>();
        for (Param option : this.params) {
            all.addAll(Arrays.asList(option.getArgs()));
        }
        return all.iterator();
    }

    public boolean hasArguments() {
        return this.params.size() > 0;
    }

    final Vector<String> getNames() {
        return this.names;
    }

    public boolean matches(String name) {
        return this.names.contains(name.toLowerCase());
    }

    int getAllowedArgs() {
        return this.nNeededArgs;
    }

    private void checkNumArgs(String[] args) throws ParseException {
        if (this.nNeededArgs == -2) {
            if (args.length <= 0) {
                throw new ParseException("option " + this.names + ": expected one or more args, found " + args.length);
            }
        } else if (this.nNeededArgs == -3) {
            if (args.length > 1) {
                throw new ParseException("option " + this.names + ": expected zero or one arg, found " + args.length);
            }
        } else if (args.length < this.nNeededArgs) {
            String msg = I18N.getInstance().get(JUMPWorkbench.I18NPREFIX + "option-{0}-needs-{1}-parameters-but-only-{2}-were-given.", StringUtils.join(this.names, (String)", "), this.nNeededArgs, args.length);
            msg = msg + "\n\n" + this.getDesc();
            throw new ParseException(msg);
        }
    }

    public Param addParam(Vector<String> v) throws ParseException {
        String[] args = v.toArray(new String[0]);
        this.checkNumArgs(args);
        String[] argsNeeded = new String[this.nNeededArgs];
        System.arraycopy(args, 0, argsNeeded, 0, this.nNeededArgs);
        Param opt = new Param(this, argsNeeded);
        this.params.add(opt);
        return opt;
    }
}

