/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import org.locationtech.jts.util.Stopwatch;

public class DebugTimer {
    private static DebugTimer timer = new DebugTimer();
    private final String blankStr;
    private final int TIME_LEN;
    private Stopwatch sw = new Stopwatch();

    public DebugTimer() {
        this.sw.start();
        this.blankStr = "          ";
        this.TIME_LEN = this.blankStr.length();
    }

    public static void startStatic(String msg) {
        timer.start(msg);
    }

    public static void logEventStatic(String msg) {
        timer.logEvent(msg);
    }

    public void start(String msg) {
        System.out.println("Started    " + msg);
        this.sw.start();
    }

    public void logEvent(String msg) {
        String elapsedStr = this.formatTime(this.sw.getTimeString());
        System.out.println("Elapsed: " + elapsedStr + "    " + msg);
        this.sw.start();
    }

    public String formatTime(String timeStr) {
        if (timeStr.length() < this.TIME_LEN) {
            String filled = this.blankStr + timeStr;
            int start = filled.length() - this.TIME_LEN;
            return filled.substring(start);
        }
        return timeStr;
    }
}

