/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.plugin.edit;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.plugin.edit.SegmentStringData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;

public class Features2SegmentStringsWithData {
    private Features2SegmentStringsWithData() {
    }

    public static List<SegmentString> getSegmentStrings(Collection<Feature> inputFeatures) {
        ArrayList<SegmentString> segmentStrings = new ArrayList<SegmentString>();
        for (Feature f : inputFeatures) {
            segmentStrings.addAll(Features2SegmentStringsWithData.getSegmentStrings(f));
        }
        return segmentStrings;
    }

    public static List<SegmentString> getSegmentStrings(Feature f) {
        Geometry g = f.getGeometry();
        ArrayList<SegmentString> segmentStrings = new ArrayList<SegmentString>();
        for (int i = 0; i < g.getNumGeometries(); ++i) {
            Geometry component = g.getGeometryN(i);
            if (component instanceof Polygon) {
                Features2SegmentStringsWithData.add((Polygon)component, f, i, segmentStrings);
                continue;
            }
            if (!(component instanceof LineString)) continue;
            Features2SegmentStringsWithData.add((LineString)component, f, i, 0, segmentStrings);
        }
        return segmentStrings;
    }

    private static void add(Polygon poly, Feature f, int i, List<SegmentString> segmentStrings) {
        Features2SegmentStringsWithData.add((LineString)poly.getExteriorRing(), f, i, 0, segmentStrings);
        for (int j = 0; j < poly.getNumInteriorRing(); ++j) {
            Features2SegmentStringsWithData.add((LineString)poly.getInteriorRingN(j), f, i, j + 1, segmentStrings);
        }
    }

    private static void add(LineString line, Feature f, int i, int j, List<SegmentString> segmentStrings) {
        NodedSegmentString ss = new NodedSegmentString(line.getCoordinates(), (Object)new SegmentStringData(f, i, j));
        segmentStrings.add((SegmentString)ss);
    }
}

