/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.GMLGeometryWriter;
import com.vividsolutions.jump.io.GMLOutputTemplate;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.io.ParseException;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorSupport;
import com.vividsolutions.jump.task.TaskMonitorUtil;
import com.vividsolutions.jump.util.Timer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;

public class GMLWriter
implements JUMPWriter,
TaskMonitorSupport {
    private static final String standard_geom = "geometry";
    private static final String standard_feature = "feature";
    private static final String standard_featureCollection = "featureCollection";
    private GMLOutputTemplate outputTemplate = null;
    private GMLGeometryWriter geometryWriter = new GMLGeometryWriter();
    static Pattern closingTagPattern = Pattern.compile(">$");
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private TaskMonitor taskMonitor = new DummyTaskMonitor();

    public GMLWriter() {
        this.geometryWriter.setLinePrefix("      ");
    }

    @Override
    public void write(FeatureCollection featureCollection, DriverProperties dp) throws Exception {
        GMLOutputTemplate gmlTemplate;
        String outputFname = dp.getProperty("File");
        if (outputFname == null) {
            outputFname = dp.getProperty("DefaultValue");
        }
        if (outputFname == null) {
            throw new IllegalParametersException("call to GMLWRite.write() has DataProperties w/o a OutputFile specified");
        }
        if (dp.getProperty("TemplateFile") == null) {
            gmlTemplate = GMLWriter.makeOutputTemplate(featureCollection);
        } else {
            FileReader r = new FileReader(dp.getProperty("TemplateFile"));
            gmlTemplate = new GMLOutputTemplate();
            gmlTemplate.load(r);
            ((Reader)r).close();
        }
        this.setOutputTemplate(gmlTemplate);
        FileOutputStream fileStream = new FileOutputStream(new File(outputFname));
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);
        this.write(featureCollection, w);
        ((Writer)w).close();
    }

    public void write(FeatureCollection featureCollection, Writer writer) throws Exception {
        if (this.outputTemplate == null) {
            throw new Exception("attempt to write GML w/o specifying the output template");
        }
        BufferedWriter buffWriter = new BufferedWriter(writer);
        buffWriter.write(this.outputTemplate.headerText);
        String srsAttrib = "";
        if (GMLWriter.getSrid(featureCollection) > 0) {
            srsAttrib = " srsName=\"http://www.opengis.net/gml/srs/epsg.xml#" + GMLWriter.getSrid(featureCollection) + "\"";
        }
        Envelope env = featureCollection.getEnvelope();
        DecimalFormat df = new DecimalFormat("#,##0.00", new DecimalFormatSymbols(Locale.US));
        df.setGroupingUsed(false);
        String envString = df.format(env.getMinX()) + "," + df.format(env.getMinY()) + " " + df.format(env.getMaxX()) + "," + df.format(env.getMaxY());
        buffWriter.write("  <gml:boundedBy>\n    <gml:Box" + srsAttrib + ">\n      <gml:coordinates decimal=\".\" cs=\",\" ts=\" \">" + envString + "</gml:coordinates>\n    </gml:Box>\n  </gml:boundedBy>\n");
        long milliSeconds = 0L;
        int count = 0;
        int size = featureCollection.size();
        TaskMonitorUtil.report(this.getTaskMonitor(), I18N.getInstance().get("Writer.writing-features"));
        Iterator<Feature> t = featureCollection.iterator();
        while (t.hasNext() && !this.getTaskMonitor().isCancelRequested()) {
            Feature f = t.next();
            for (int u = 0; u < this.outputTemplate.featureText.size(); ++u) {
                String pre = this.outputTemplate.featureText.get(u);
                String token = this.outputTemplate.codingText.get(u);
                this.evaluateToken(f, pre, token, buffWriter);
            }
            buffWriter.write(this.outputTemplate.featureTextfooter);
            buffWriter.write("\n");
            long now = Timer.milliSecondsSince(0L);
            ++count;
            if (now - 500L < milliSeconds) continue;
            milliSeconds = now;
            TaskMonitorUtil.report(this.getTaskMonitor(), count, size, "");
        }
        buffWriter.write(this.outputTemplate.footerText);
        buffWriter.flush();
    }

    private static String escapeXML(String s) {
        if (s == null) {
            return null;
        }
        return StringEscapeUtils.escapeXml10((String)s);
    }

    private static int getSrid(FeatureCollection featureCollection) {
        Integer srid = -1;
        CoordinateSystem cs = featureCollection.getFeatureSchema().getCoordinateSystem();
        if (!cs.equals(CoordinateSystem.UNSPECIFIED)) {
            srid = cs.getEPSGCode();
        }
        return srid;
    }

    void setOutputTemplate(GMLOutputTemplate ot) {
        this.outputTemplate = ot;
    }

    private String evaluateToken(Feature f, String token) throws Exception {
        if (!(token = token.trim()).startsWith("=") || token.length() < 7) {
            throw new ParseException("couldn't understand token '" + token + "' in the output template");
        }
        token = token.substring(1);
        int index = (token = token.trim()).indexOf(" ");
        String cmd = index == -1 ? token : token.substring(0, token.indexOf(" "));
        if (cmd.equalsIgnoreCase("column")) {
            String column = token.substring(6);
            column = column.trim();
            String result = this.toString(f, column);
            result = GMLWriter.escapeXML(result);
            return result;
        }
        if (cmd.equalsIgnoreCase(standard_geom)) {
            this.geometryWriter.setMaximumCoordinatesPerLine(1);
            return this.geometryWriter.write(f.getGeometry());
        }
        if (cmd.equalsIgnoreCase("geometrytype")) {
            return f.getGeometry().getGeometryType();
        }
        throw new ParseException("couldn't understand token '" + token + "' in the output template");
    }

    private void evaluateToken(Feature f, String pre, String token, Writer writer) throws Exception {
        if (!(token = token.trim()).startsWith("=") || token.length() < 7) {
            throw new ParseException("couldn't understand token '" + token + "' in the output template");
        }
        token = token.substring(1);
        int index = (token = token.trim()).indexOf(" ");
        String cmd = index == -1 ? token : token.substring(0, token.indexOf(" "));
        if (cmd.equalsIgnoreCase("column")) {
            String column = token.substring(6);
            column = column.trim();
            String result = this.toString(f, column);
            if ((result = GMLWriter.escapeXML(result)) == null) {
                writer.append(closingTagPattern.matcher(pre).replaceAll(" xsi:nil=\"true\">"));
            } else {
                writer.append(pre).append(result);
            }
        } else if (cmd.equalsIgnoreCase(standard_geom)) {
            this.geometryWriter.setMaximumCoordinatesPerLine(1);
            writer.append(pre);
            this.geometryWriter.write(f.getGeometry(), writer);
        } else if (cmd.equalsIgnoreCase("geometrytype")) {
            writer.append(pre);
            writer.append(f.getGeometry().getGeometryType());
        } else {
            throw new ParseException("couldn't understand token '" + token + "' in the output template");
        }
    }

    protected String toString(Feature f, String column) {
        Assert.isTrue((f.getSchema().getAttributeType(column) != AttributeType.GEOMETRY ? 1 : 0) != 0);
        Object attribute = f.getAttribute(column);
        if (attribute == null) {
            return null;
        }
        if (attribute instanceof Date) {
            return this.format((Date)attribute);
        }
        return attribute.toString();
    }

    protected String format(Date date) {
        return dateFormatter.format(date);
    }

    private static GMLOutputTemplate makeOutputTemplate(FeatureCollection fc) {
        FeatureSchema fcmd = fc.getFeatureSchema();
        GMLOutputTemplate result = new GMLOutputTemplate();
        String inputTemplate = GMLWriter.makeInputTemplate(fc);
        result.setHeaderText("<?xml version='1.0' encoding='UTF-8'?>\n<JCSDataFile xmlns:gml=\"http://www.opengis.net/gml\" xmlns:xsi=\"http://www.w3.org/2000/10/XMLSchema-instance\" >\n" + inputTemplate + "<" + standard_featureCollection + ">\n");
        String colHeader = "  <feature>\n";
        for (int t = 0; t < fcmd.getAttributeCount(); ++t) {
            String colCode;
            String colText;
            String colName = fcmd.getAttributeName(t);
            if (t != fcmd.getGeometryIndex()) {
                colText = colHeader + "    <property name=\"" + GMLWriter.escapeXML(colName) + "\">";
                colCode = "=column " + colName;
                colHeader = "</property>\n";
            } else {
                colText = colHeader + "    <" + standard_geom + ">\n";
                colCode = "=geometry";
                colHeader = "    </geometry>\n";
            }
            result.addItem(colText, colCode);
        }
        result.setFeatureFooter(colHeader + "  </" + standard_feature + ">");
        result.setFooterText("</featureCollection>\n</JCSDataFile>\n");
        return result;
    }

    private static String makeInputTemplate(FeatureCollection fc) {
        String result = "";
        FeatureSchema fcmd = fc.getFeatureSchema();
        result = result + "<JCSGMLInputTemplate>\n";
        result = result + "<CollectionElement>featureCollection</CollectionElement>\n";
        result = result + "<FeatureElement>feature</FeatureElement>\n";
        result = result + "<GeometryElement>geometry</GeometryElement>\n";
        result = result + "<CRSElement>boundedBy</CRSElement>\n";
        result = result + "<ColumnDefinitions>\n";
        for (int t = 0; t < fcmd.getAttributeCount(); ++t) {
            String colName = fcmd.getAttributeName(t);
            if (t == fcmd.getGeometryIndex()) continue;
            String colDef = "     <column>\n";
            colDef = colDef + "          <name>" + GMLWriter.escapeXML(colName) + "</name>\n";
            AttributeType attributeType = fcmd.getAttributeType(t);
            colDef = colDef + "          <type>" + GMLWriter.escapeXML(attributeType.toString()) + "</type>\n";
            colDef = colDef + "          <valueElement elementName=\"property\" attributeName=\"name\" attributeValue=\"" + GMLWriter.escapeXML(colName) + "\"/>\n";
            colDef = colDef + "          <valueLocation position=\"body\"/>\n";
            colDef = colDef + "     </column>\n";
            result = result + colDef;
        }
        result = result + "</ColumnDefinitions>\n</JCSGMLInputTemplate>\n\n";
        return result;
    }

    @Override
    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    @Override
    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }
}

