/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.AbstractJUMPReader;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.GMLInputTemplate;
import com.vividsolutions.jump.io.GMLReader;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.ParseException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;

public class FMEGMLReader
extends AbstractJUMPReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureCollection read(DriverProperties dp) throws Exception {
        FeatureCollection result;
        GMLInputTemplate inputTemplate;
        GMLReader gmlReader = new GMLReader();
        boolean isCompressed = dp.getProperty("CompressedFile") != null;
        String inputfname = dp.getProperty(DriverProperties.DEFAULT_VALUE_KEY);
        if (inputfname == null) {
            inputfname = dp.getProperty("File");
        }
        if (inputfname == null) {
            throw new IllegalParametersException("call to FMEReader.read() has DataProperties w/o a InputFile specified");
        }
        try (InputStream inputStream = isCompressed ? CompressedFile.openFile(inputfname, dp.getProperty("CompressedFile")) : new BufferedInputStream(new FileInputStream(inputfname));){
            try {
                inputTemplate = this.getGMLInputTemplate(inputStream, inputfname);
            }
            finally {
                inputStream.close();
            }
        }
        inputStream = isCompressed ? CompressedFile.openFile(inputfname, dp.getProperty("CompressedFile")) : new BufferedInputStream(new FileInputStream(inputfname));
        try {
            gmlReader.setInputTemplate(inputTemplate);
            try {
                result = gmlReader.read(inputStream, inputfname);
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            inputStream.close();
        }
        return result;
    }

    public GMLInputTemplate getGMLInputTemplate(InputStream inputStream, String fname) throws IOException, ParseException {
        String columnDef;
        String s;
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        boolean foundStartTag = false;
        boolean foundEndTag = false;
        for (int lineNo = 0; !foundStartTag && lineNo < 10; ++lineNo) {
            s = reader.readLine();
            if (s != null) continue;
            throw new ParseException("Couldn't find a <schemaFeatures> tag in the input FME GML file.  This isn't a valid FME GML file.");
        }
        if (!foundStartTag) {
            throw new ParseException("Read first 10 lines of " + fname + " and couldn't find a <schemaFeatures> tag.  This isn't a valid FME GML file.");
        }
        String columns = "";
        while (!foundEndTag) {
            s = reader.readLine();
            if (s.contains("</schemaFeatures>")) {
                foundEndTag = true;
            }
            if (!s.contains("<property fme:name") && !s.contains("<property name")) continue;
            String propertyNamePrefix = "";
            if (s.contains("<property fme:name")) {
                propertyNamePrefix = "fme:";
            }
            int start = s.indexOf("\"");
            int end = s.indexOf("\"", start + 1);
            if (start == -1 || end == -1) {
                throw new ParseException("Parsing file " + fname + " couldn't get column name on line # " + reader.getLineNumber() + " - " + s);
            }
            String columnName = s.substring(start + 1, end);
            start = s.indexOf(">");
            end = s.indexOf("<", start + 1);
            if (start == -1 || end == -1) {
                throw new ParseException("Parsing file " + fname + " couldn't get column type on line # " + reader.getLineNumber() + " - " + s);
            }
            String columnType = this.FMEtypeToJCSType(s.substring(start + 1, end));
            columnDef = "     <column>\n     <name>" + columnName + "</name>\n          <type>" + columnType + "</type>\n";
            columnDef = columnDef + "         <valueElement elementName=\"property\" attributeName=\"" + propertyNamePrefix + "name\" attributeValue=\"" + columnName + "\" />\n";
            columnDef = columnDef + "         <valueLocation position=\"body\" />\n";
            columnDef = columnDef + "     </column>\n";
            columns = columns + columnDef;
        }
        columnDef = "     <column>\n     <name>featuretype</name>\n";
        columnDef = columnDef + "           <type>STRING</type>\n";
        columnDef = columnDef + "           <valueElement elementName=\"featureType\"/>\n";
        columnDef = columnDef + "           <valueLocation position=\"body\"/>\n";
        columnDef = columnDef + "     </column>\n";
        columns = columns + columnDef;
        String templateText = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        templateText = templateText + "<JCSGMLInputTemplate>\n";
        templateText = templateText + "     <CollectionElement>dataFeatures</CollectionElement>\n";
        templateText = templateText + "     <FeatureElement>Feature</FeatureElement>\n";
        templateText = templateText + "     <GeometryElement>gml:PointProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:PolygonProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:LineStringProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiPointProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiPolygonProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiLineStringProperty</GeometryElement>\n";
        templateText = templateText + "     <GeometryElement>gml:MultiGeometryProperty</GeometryElement>\n";
        templateText = templateText + "     <ColumnDefinitions>\n";
        templateText = templateText + columns;
        templateText = templateText + "     </ColumnDefinitions>\n";
        templateText = templateText + "</JCSGMLInputTemplate>\n";
        ByteArrayInputStream is = new ByteArrayInputStream(templateText.getBytes(StandardCharsets.UTF_8));
        GMLInputTemplate result = new GMLInputTemplate();
        result.load(is, "Auto created FME GML input template");
        ((InputStream)is).close();
        return result;
    }

    private String FMEtypeToJCSType(String fmeType) {
        if (fmeType.contains("fme_char")) {
            return "STRING";
        }
        if (fmeType.contains("fme_decimal")) {
            int loc = fmeType.indexOf(",");
            if (loc == -1 || loc == fmeType.length() - 1) {
                return "STRING";
            }
            if (fmeType.substring(loc + 1, loc + 2).equalsIgnoreCase("0")) {
                return "INTEGER";
            }
            return "DOUBLE";
        }
        if (fmeType.contains("long")) {
            return "DOUBLE";
        }
        return "STRING";
    }
}

