/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialite;

import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.GeometryColumn;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.datastore.spatialite.GeometricColumnType;
import com.vividsolutions.jump.datastore.spatialite.GeometryColumnsLayout;
import com.vividsolutions.jump.datastore.spatialite.SpatialiteDSMetadata;
import com.vividsolutions.jump.workbench.Logger;
import java.util.Locale;
import org.locationtech.jts.geom.Envelope;

public class SpatialiteSQLBuilder
extends SpatialDatabasesSQLBuilder {
    private String datasetName;

    public SpatialiteSQLBuilder(SpatialiteDSMetadata dsMetadata, SpatialReferenceSystemID defaultSRID, String[] colNames) {
        super(dsMetadata, defaultSRID, colNames);
    }

    @Override
    public String getSQL(FilterQuery query) {
        this.datasetName = query.getDatasetName();
        StringBuilder qs = new StringBuilder();
        String ret = "SELECT %s FROM %s WHERE %s AND (%s) %s";
        String cols = this.getColumnListSpecifier(this.colNames, query.getGeometryAttributeName());
        String bbox = this.buildBoxFilter(query);
        String and = query.getCondition() == null ? "1" : query.getCondition();
        String lim = query.getLimit() != 0 && query.getLimit() != Integer.MAX_VALUE ? " LIMIT " + query.getLimit() : "";
        String s = String.format(ret, cols, SQLUtil.quote(this.datasetName), bbox, and, lim);
        Logger.trace("SQL query to get Spatial table features:\n\t" + s);
        return s;
    }

    @Override
    public String getCheckSQL(DataStoreLayer dsLayer) {
        String s = "select * FROM %s %s LIMIT 0";
        String wc = dsLayer.getWhereClause();
        wc = wc != null && !wc.isEmpty() ? " WHERE " + wc : "";
        return String.format(s, dsLayer.getFullName(), wc);
    }

    @Override
    protected String getColumnListSpecifier(String[] colNames, String geomColName) {
        StringBuilder buf = new StringBuilder();
        SpatialiteDSMetadata dsm = (SpatialiteDSMetadata)this.getDbMetadata();
        GeometricColumnType gcType = dsm.getGeoColTypesdMap().get(this.datasetName.toLowerCase() + "." + geomColName.toLowerCase());
        String s = null;
        switch (gcType) {
            case SPATIALITE: {
                s = geomColName;
                break;
            }
            case WKB: {
                s = String.format("st_geomFromWkb(%s) as %s", geomColName, geomColName);
                break;
            }
            case WKT: {
                s = String.format("st_geomFromText(%s) as %s", geomColName, geomColName);
            }
        }
        buf.append("").append(geomColName);
        for (String colName : colNames) {
            if (geomColName.equalsIgnoreCase(colName)) continue;
            buf.append(",").append(colName);
        }
        return buf.toString();
    }

    @Override
    protected String buildBoxFilter(FilterQuery query) {
        Envelope env = query.getFilterGeometry().getEnvelopeInternal();
        String ret = "1";
        String indexQuery = this.buildSpatialIndexFilter(query);
        SpatialiteDSMetadata dsm = (SpatialiteDSMetadata)this.getDbMetadata();
        if (dsm.isSpatialiteLoaded()) {
            GeometricColumnType gcType = dsm.getGeoColTypesdMap().get(query.getDatasetName().toLowerCase() + "." + query.getGeometryAttributeName().toLowerCase());
            if (gcType == GeometricColumnType.SPATIALITE) {
                ret = String.format(Locale.US, "st_envIntersects(CastAutomagic(%s), %f,%f,%f,%f)", query.getGeometryAttributeName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
            } else if (gcType == GeometricColumnType.WKB) {
                ret = String.format(Locale.US, "st_envIntersects(st_geomFromWkb(%s), %f,%f,%f,%f)", query.getGeometryAttributeName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
            } else if (gcType == GeometricColumnType.WKT) {
                ret = String.format(Locale.US, "st_envIntersects(st_geomFromText(%s), %f,%f,%f,%f)", query.getGeometryAttributeName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
            } else {
                Logger.error("Spatialite SQL builder: invalid geometric column type: " + (Object)((Object)gcType));
            }
        }
        ret = ret + indexQuery;
        return ret;
    }

    protected String buildSpatialIndexFilter(FilterQuery query) {
        String ret = "";
        Envelope env = query.getFilterGeometry().getEnvelopeInternal();
        SpatialiteDSMetadata dsm = (SpatialiteDSMetadata)this.getDbMetadata();
        GeometryColumn gc = dsm.getGeometryColumn(query.getDatasetName(), query.getGeometryAttributeName());
        if (gc == null) {
            return ret;
        }
        if (gc.isIndexed() == null) {
            dsm.setIndexInfo(this.datasetName, gc);
        }
        if (gc.isIndexed().booleanValue()) {
            if (dsm.getGeometryColumnsLayout() == GeometryColumnsLayout.OGC_GEOPACKAGE_LAYOUT) {
                String idxName = SQLUtil.quote(String.format("rtree_%s_%s", query.getDatasetName(), query.getGeometryAttributeName()));
                ret = String.format(Locale.US, " AND ROWID IN (SELECT id FROM %s WHERE minx < %f and maxx > %f and miny < %f and maxy > %f) ", idxName, env.getMaxX(), env.getMinX(), env.getMaxY(), env.getMinY());
            } else if (dsm.isSpatialiteLoaded()) {
                ret = String.format(Locale.US, " AND ROWID IN (SELECT ROWID FROM SpatialIndex WHERE f_table_name = '%s' AND search_frame = BuildMbr(%f,%f,%f,%f))", query.getDatasetName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY());
            }
        }
        return ret;
    }
}

