/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.oracle;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.oracle.OracleDSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.AbstractSpatialDatabasesDSDriver;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.sql.Connection;
import javax.swing.Icon;

public class OracleDataStoreDriver
extends AbstractSpatialDatabasesDSDriver {
    public static final String JDBC_CLASS = "oracle.jdbc.driver.OracleDriver";
    public static final String GT_SDO_CLASS_NAME = "org.geotools.data.oracle.sdo.SDO";

    public OracleDataStoreDriver() {
        this.driverName = "Oracle Spatial";
        this.jdbcClass = JDBC_CLASS;
        this.urlPrefix = "jdbc:oracle:thin:@//";
    }

    @Override
    public DataStoreConnection createConnection(ParameterList params) throws Exception {
        Connection conn = super.createJdbcConnection(params);
        return new OracleDSConnection(conn);
    }

    @Override
    public Icon getConnectedIcon() {
        return IconLoader.icon("ok_oracle.png");
    }

    @Override
    public Icon getDisconnectedIcon() {
        return IconLoader.icon("ko_oracle.png");
    }
}

