/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.h2;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.AdhocQuery;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.h2.H2DSMetadata;
import com.vividsolutions.jump.datastore.h2.H2FeatureInputStream;
import com.vividsolutions.jump.datastore.h2.H2SQLBuilder;
import com.vividsolutions.jump.datastore.h2.H2ValueConverterFactory;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSConnection;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.FeatureInputStream;
import java.sql.Connection;
import java.sql.SQLException;

public class H2DSConnection
extends SpatialDatabasesDSConnection {
    public H2DSConnection(Connection con) {
        super(con);
        this.dbMetadata = new H2DSMetadata(this);
    }

    @Override
    public SpatialDatabasesSQLBuilder getSqlBuilder(SpatialReferenceSystemID srid, String[] colNames) {
        return new H2SQLBuilder(this.dbMetadata, srid, colNames);
    }

    @Override
    public FeatureInputStream executeFilterQuery(FilterQuery query) throws SQLException {
        SpatialReferenceSystemID srid = this.dbMetadata.getSRID(query.getDatasetName(), query.getGeometryAttributeName());
        String[] colNames = this.dbMetadata.getColumnNames(query.getDatasetName());
        H2SQLBuilder builder = (H2SQLBuilder)this.getSqlBuilder(srid, colNames);
        String queryString = builder.getSQL(query);
        return new H2FeatureInputStream(this.connection, queryString, query.getPrimaryKey());
    }

    @Override
    public FeatureInputStream executeAdhocQuery(AdhocQuery query) throws Exception {
        FeatureSchema fs;
        String queryString = query.getQuery();
        H2FeatureInputStream ifs = new H2FeatureInputStream(this.connection, queryString, query.getPrimaryKey());
        try {
            fs = ifs.getFeatureSchema();
        }
        catch (Exception e) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".SQL-error") + e.getMessage());
        }
        if (fs.getGeometryIndex() < 0) {
            throw new Exception(I18N.getInstance().get(SpatialDatabasesDSConnection.class.getName() + ".resultset-must-have-a-geometry-column"));
        }
        return ifs;
    }

    @Override
    public H2ValueConverterFactory getValueConverterFactory() {
        return new H2ValueConverterFactory(this.connection);
    }
}

